/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.logging.ILogger;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LifecycleServiceImpl
implements LifecycleService {
    private final HazelcastInstanceImpl instance;
    private final ConcurrentMap<String, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<String, LifecycleListener>();
    private final Object lifecycleLock = new Object();

    public LifecycleServiceImpl(HazelcastInstanceImpl instance) {
        this.instance = instance;
    }

    private ILogger getLogger() {
        return this.instance.node.getLogger(LifecycleService.class.getName());
    }

    @Override
    public String addLifecycleListener(LifecycleListener lifecycleListener) {
        String id = UUID.randomUUID().toString();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    @Override
    public boolean removeLifecycleListener(String registrationId) {
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        this.fireLifecycleEvent(new LifecycleEvent(lifecycleState));
    }

    public void fireLifecycleEvent(LifecycleEvent lifecycleEvent) {
        this.getLogger().info(this.instance.node.getThisAddress() + " is " + (Object)((Object)lifecycleEvent.getState()));
        for (LifecycleListener lifecycleListener : this.lifecycleListeners.values()) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.instance.node.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            this.instance.managementService.destroy();
            this.instance.node.shutdown(false);
            HazelcastInstanceFactory.remove(this.instance);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            this.instance.managementService.destroy();
            this.instance.node.shutdown(true);
            HazelcastInstanceFactory.remove(this.instance);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnderLifecycleLock(Runnable runnable) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            runnable.run();
        }
    }
}

