/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.NearCache;
import com.hazelcast.map.SizeEstimator;
import java.util.concurrent.atomic.AtomicLong;

class NearCacheSizeEstimator
implements SizeEstimator<NearCache.CacheRecord> {
    private final AtomicLong _size = new AtomicLong(0L);

    protected NearCacheSizeEstimator() {
    }

    @Override
    public long getCost(NearCache.CacheRecord record) {
        if (record == null) {
            return 0L;
        }
        long cost = record.getCost();
        if (cost == 0L) {
            return 0L;
        }
        long size = 0L;
        size += 16L;
        return size += cost;
    }

    @Override
    public long getSize() {
        return this._size.longValue();
    }

    @Override
    public void add(long size) {
        this._size.addAndGet(size);
    }

    @Override
    public void reset() {
        this._size.set(0L);
    }
}

