/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rv;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvProcessor;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snaccmd.icbm.RvCommand;

public class RecvRvEvent
extends SnacPacketEvent {
    public static final String TYPE_RV = "TYPE_RV";
    public static final String TYPE_RESPONSE = "TYPE_RESPONSE";
    private final String type;
    private final RvProcessor rvProcessor;
    private final RvSession rvSession;
    private final RvCommand rvCommand;
    private final int responseCode;

    protected RecvRvEvent(SnacPacketEvent other, RvProcessor processor, RvSession session, RvCommand command) {
        this(TYPE_RV, other, processor, session, command, -1);
    }

    protected RecvRvEvent(SnacPacketEvent other, RvProcessor processor, RvSession session, int resultCode) {
        this(TYPE_RV, other, processor, session, null, resultCode);
        DefensiveTools.checkRange((int)resultCode, (String)"resultCode", (int)-1);
    }

    private RecvRvEvent(String type, SnacPacketEvent other, RvProcessor rvProcessor, RvSession rvSession, RvCommand rvCommand, int responseCode) {
        super(other);
        DefensiveTools.checkNull((Object)type, (String)"type");
        DefensiveTools.checkNull((Object)rvProcessor, (String)"rvProcessor");
        DefensiveTools.checkNull((Object)rvSession, (String)"rvSession");
        if (type != TYPE_RV && type != TYPE_RESPONSE) {
            throw new IllegalArgumentException("type (" + type + ") must be " + "one of TYPE_RV and TYPE_RESPONSE");
        }
        if (rvCommand != null && responseCode != -1) {
            throw new IllegalArgumentException("only one of rvCommand and responseCode can have a non-null or nonnegative value");
        }
        this.type = type;
        this.rvProcessor = rvProcessor;
        this.rvSession = rvSession;
        this.rvCommand = rvCommand;
        this.responseCode = responseCode;
    }

    public final String getRvEventType() {
        return this.type;
    }

    public final RvProcessor getRvProcessor() {
        return this.rvProcessor;
    }

    public final RvSession getRvSession() {
        return this.rvSession;
    }

    public final RvCommand getRvCommand() {
        return this.rvCommand;
    }

    public final int getRvResponseCode() {
        return this.responseCode;
    }

    public String toString() {
        return "RecvRvEvent for " + this.rvSession.getScreenname() + ": " + (this.type == TYPE_RV ? "rvCommand=" + this.rvCommand : "rvResponseCode=" + this.responseCode);
    }
}

