/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnFileTransfer;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.event.MsnSwitchboardAdapter;
import net.sf.jml.impl.MsnFileTransferImpl;
import net.sf.jml.message.p2p.FileTransferWorker;
import net.sf.jml.message.p2p.MsnFileContextParser;
import net.sf.jml.message.p2p.MsnFileInviteMessage;
import net.sf.jml.message.p2p.MsnP2PBaseIdGenerator;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.msnslp.MsnslpRequest;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileTransferManager {
    private static final Log logger = LogFactory.getLog(FileTransferManager.class);
    private Hashtable<String, FileTransferWorker> activeFileTransfers = new Hashtable();
    private MsnSession session = null;

    public void addFileTransfer(String string, FileTransferWorker fileTransferWorker) {
        this.activeFileTransfers.put(string, fileTransferWorker);
    }

    public void removeFileTransfer(String string) {
        this.activeFileTransfers.remove(string);
    }

    public MsnFileTransfer getFileTransfer(String string) {
        FileTransferWorker fileTransferWorker = this.activeFileTransfers.get(string);
        if (fileTransferWorker == null) {
            return null;
        }
        return fileTransferWorker.getFileTransfer();
    }

    public FileTransferWorker getFileTransferWorker(String string) {
        return this.activeFileTransfers.get(string);
    }

    private String generateNewCallId() {
        int n = NumberUtils.getIntRandom();
        String string = NumberUtils.toHexValue(n);
        return "{2B073406-65D8-A7B2-5B13-B287" + string + "}";
    }

    public MsnFileTransfer sendFile(Email email, File file) {
        MsnSwitchboard[] msnSwitchboardArray;
        if (email == null || file == null) {
            return null;
        }
        MsnContact msnContact = this.session.getMessenger().getContactList().getContactByEmail(email);
        if (msnContact != null && msnContact.getStatus().equals(MsnUserStatus.OFFLINE)) {
            logger.warn((Object)"Contact is either null or offline cannot send file");
            return null;
        }
        MsnSwitchboard msnSwitchboard = null;
        for (MsnSwitchboard msnSwitchboard2 : msnSwitchboardArray = this.session.getMessenger().getActiveSwitchboards()) {
            if (!msnSwitchboard2.containContact(email) || msnSwitchboard2.getAllContacts().length != 1) continue;
            msnSwitchboard = msnSwitchboard2;
            break;
        }
        if (msnSwitchboard == null) {
            Object object = new Object();
            SwitchboardListener switchboardListener = new SwitchboardListener(object, email, file);
            this.session.getMessenger().addSwitchboardListener(switchboardListener);
            this.session.getMessenger().newSwitchboard(object);
            return switchboardListener.waitForFileTransfer(15000L);
        }
        return this.sendFile(msnSwitchboard, email, file);
    }

    private MsnFileTransfer sendFile(MsnSwitchboard msnSwitchboard, Email email, File file) {
        OutgoingMSG[] outgoingMSGArray;
        MsnslpRequest msnslpRequest = new MsnslpRequest();
        MsnFileInviteMessage msnFileInviteMessage = new MsnFileInviteMessage(){

            protected void receivedResponse(MsnSession msnSession, MsnIncomingMessage msnIncomingMessage) {
                if (this.getOffset() + (long)this.getCurrentLength() < this.getTotalLength()) {
                    OutgoingMSG[] outgoingMSGArray;
                    this.binaryHeader.rewind();
                    this.setOffset(this.getCurrentLength());
                    long l = this.getTotalLength() - (long)this.getCurrentLength();
                    if (l > 1202L) {
                        this.setCurrentLength(1202);
                    } else {
                        this.setCurrentLength((int)l);
                    }
                    for (OutgoingMSG outgoingMSG : outgoingMSGArray = this.toOutgoingMsg(msnSession.getMessenger().getActualMsnProtocol())) {
                        msnSession.sendSynchronousMessage(outgoingMSG);
                    }
                }
            }
        };
        msnFileInviteMessage.setSlpMessage(msnslpRequest);
        int n = NumberUtils.getIntRandom();
        msnFileInviteMessage.setP2PDest(email.getEmailAddress());
        msnFileInviteMessage.setIdentifier(MsnP2PBaseIdGenerator.getInstance().getNextId());
        msnFileInviteMessage.setFlag(0x1000000);
        msnFileInviteMessage.setField7(n);
        msnFileInviteMessage.setField8(0);
        msnFileInviteMessage.setField9(0L);
        msnslpRequest.setRequestMethod("INVITE");
        msnslpRequest.setRequestURI("MSNMSGR:" + email.getEmailAddress());
        msnslpRequest.setTo("<msnmsgr:" + email.getEmailAddress() + ">");
        msnslpRequest.setFrom("<msnmsgr:" + this.session.getMessenger().getOwner().getEmail().getEmailAddress() + ">");
        msnslpRequest.setVia("MSNSLP/1.0/TLP ;branch=" + this.generateNewCallId());
        msnslpRequest.setCSeq(0);
        msnslpRequest.setCallId(this.generateNewCallId());
        msnslpRequest.setMaxForwards(0);
        msnslpRequest.setContentType("application/x-msnmsgr-sessionreqbody");
        StringHolder stringHolder = new StringHolder();
        stringHolder.setProperty("EUF-GUID", "{5D3E02AB-6190-11D3-BBBB-00C04F795683}");
        stringHolder.setProperty("SessionID", n);
        stringHolder.setProperty("AppID", 2);
        try {
            stringHolder.setProperty("Context", MsnFileContextParser.getEncodedContext(file));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error((Object)"", (Throwable)unsupportedEncodingException);
        }
        msnslpRequest.setBody(stringHolder.toString() + "\r\n" + "\u0000");
        int n2 = Charset.encodeAsByteArray(msnslpRequest.toString()).length;
        msnFileInviteMessage.setTotalLength(n2);
        if (n2 > 1202) {
            msnFileInviteMessage.setCurrentLength(1202);
            msnFileInviteMessage.setOffset(0L);
        } else {
            msnFileInviteMessage.setCurrentLength(n2);
        }
        String string = String.valueOf(n);
        MsnFileTransferImpl msnFileTransferImpl = new MsnFileTransferImpl(string, email, msnFileInviteMessage, this.session, true);
        msnFileTransferImpl.setFile(file);
        msnFileTransferImpl.setFileTotalSize(file.length());
        FileTransferWorker fileTransferWorker = new FileTransferWorker(msnFileTransferImpl);
        fileTransferWorker.setSwitchboard(msnSwitchboard);
        this.session.getMessenger().getFileTransferManager().addFileTransfer(string, fileTransferWorker);
        for (OutgoingMSG outgoingMSG : outgoingMSGArray = msnFileInviteMessage.toOutgoingMsg(this.session.getMessenger().getActualMsnProtocol())) {
            msnSwitchboard.send(outgoingMSG);
        }
        return msnFileTransferImpl;
    }

    public void setSession(MsnSession msnSession) {
        this.session = msnSession;
    }

    private class SwitchboardListener
    extends MsnSwitchboardAdapter {
        Object attachment = null;
        Email email = null;
        File file = null;
        MsnFileTransfer fileTransfer = null;

        SwitchboardListener(Object object, Email email, File file) {
            this.attachment = object;
            this.email = email;
            this.file = file;
        }

        public void switchboardStarted(MsnSwitchboard msnSwitchboard) {
            if (msnSwitchboard.getAttachment() == this.attachment) {
                msnSwitchboard.inviteContact(this.email);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contactJoinSwitchboard(MsnSwitchboard msnSwitchboard, MsnContact msnContact) {
            if (msnSwitchboard.getAttachment() == this.attachment && this.email.equals(msnContact.getEmail())) {
                msnSwitchboard.setAttachment(null);
                FileTransferManager.this.session.getMessenger().removeSwitchboardListener(this);
                this.fileTransfer = FileTransferManager.this.sendFile(msnSwitchboard, this.email, this.file);
                SwitchboardListener switchboardListener = this;
                synchronized (switchboardListener) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MsnFileTransfer waitForFileTransfer(long l) {
            logger.trace((Object)"Waiting for a FileTransfer Status Event");
            SwitchboardListener switchboardListener = this;
            synchronized (switchboardListener) {
                if (this.fileTransfer != null) {
                    return this.fileTransfer;
                }
                try {
                    this.wait(l);
                    if (this.fileTransfer != null) {
                        logger.trace((Object)"Received a FileTransfer.");
                    } else {
                        logger.trace((Object)("No FileTransfer received for " + l + "ms."));
                    }
                    return this.fileTransfer;
                }
                catch (InterruptedException interruptedException) {
                    logger.debug((Object)"Interrupted while waiting for a FileTransfer", (Throwable)interruptedException);
                    return null;
                }
            }
        }
    }
}

