/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import org.jdesktop.jdic.browser.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;

public class JdicManager {
    private boolean isShareNativeInitialized = false;
    private boolean isBrowserNativeInitialized = false;
    boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    String libPathEnv = this.isWindows ? "PATH" : "LD_LIBRARY_PATH";
    String binaryPath = null;
    private static JdicManager sSingleton = null;

    private JdicManager() {
    }

    public static synchronized JdicManager getManager() {
        if (sSingleton == null) {
            sSingleton = new JdicManager();
        }
        return sSingleton;
    }

    public void initShareNative() throws JdicInitException {
        if (this.isShareNativeInitialized) {
            return;
        }
        try {
            Object object;
            Object object2;
            String string = this.getClass().getName().replaceAll("\\.", "/") + ".class";
            String string2 = string.replaceAll("[^/]+", "..").substring(3);
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (uRL == null) {
                throw new JdicInitException("Unable to locate " + string + " in ClassLoader");
            }
            URL uRL2 = new URL(uRL, string2);
            if ("file".equals(uRL2.getProtocol())) {
                this.binaryPath = new File(uRL2.getFile()).toString();
            } else {
                object2 = new URL(uRL2, "..");
                object2 = new URL(new URL(((URL)object2).toString().substring(4)), "./");
                if (System.getProperty("javawebstart.version") != null) {
                    object = "RNjdic-native.jar/";
                    File file = new File(new URL((URL)object2, (String)object).getFile());
                    this.binaryPath = file.toString();
                } else if ("jar".equals(uRL2.getProtocol())) {
                    this.binaryPath = new File(((URL)object2).getFile()).toString();
                }
            }
            if (this.isWindows) {
                try {
                    this.binaryPath = URLDecoder.decode(this.binaryPath, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            object2 = this.binaryPath + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", (String)object2);
            object = ClassLoader.class.getDeclaredField("sys_paths");
            ((Field)object).setAccessible(true);
            if (object != null) {
                ((Field)object).set(System.class.getClassLoader(), null);
            }
            InitUtility.appendEnv(this.libPathEnv, this.binaryPath);
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isShareNativeInitialized = true;
    }

    public void initBrowserNative() throws JdicInitException {
        if (this.isBrowserNativeInitialized) {
            return;
        }
        try {
            String string = WebBrowserUtil.getBrowserPath();
            if (string == null) {
                throw new JdicInitException("Can't locate the native browser path!");
            }
            if (WebBrowserUtil.isDefaultBrowserMozilla()) {
                Object object;
                String string2;
                if (!this.isWindows) {
                    InitUtility.appendEnv("PATH", this.binaryPath);
                }
                if ((string2 = InitUtility.getEnv("MOZILLA_FIVE_HOME")) == null) {
                    object = new File(string);
                    string2 = ((File)object).isDirectory() ? ((File)object).getCanonicalPath() : ((File)object).getCanonicalFile().getParent();
                    InitUtility.appendEnv("MOZILLA_FIVE_HOME", string2);
                    InitUtility.appendEnv(this.libPathEnv, string2);
                }
                if (this.isWindows) {
                    object = this.binaryPath + File.separator + "MozEmbed.exe";
                    String string3 = string2 + File.separator + "MozEmbed.exe";
                    InitUtility.copyFile((String)object, string3);
                }
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isBrowserNativeInitialized = true;
    }
}

