/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.DNSCache;
import javax.jmdns.DNSEntry;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSListener;
import javax.jmdns.DNSOutgoing;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;
import javax.jmdns.DNSState;
import javax.jmdns.HostInfo;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class JmDNS {
    private static Logger logger = Logger.getLogger((class$javax$jmdns$JmDNS == null ? (class$javax$jmdns$JmDNS = JmDNS.class$("javax.jmdns.JmDNS")) : class$javax$jmdns$JmDNS).toString());
    public static String VERSION = "0.4.2";
    private InetAddress group;
    private MulticastSocket socket;
    private List listeners;
    private Map serviceListeners;
    private List typeListeners;
    private DNSCache cache;
    Hashtable services;
    Hashtable serviceTypes;
    private Thread shutdown;
    HostInfo localHost;
    private Thread incomingListener = null;
    private int throttle;
    private long lastThrottleIncrement;
    private Timer timer;
    private static final Random random = new Random();
    private Object ioLock = new Object();
    private DNSIncoming plannedAnswer;
    private DNSState state = DNSState.PROBING_1;
    TimerTask task;
    private HashMap serviceCollectors = new HashMap();
    static /* synthetic */ Class class$javax$jmdns$JmDNS;
    static /* synthetic */ Class class$javax$jmdns$JmDNS$ServiceCollector;

    public JmDNS() throws IOException {
        logger.finer("JmDNS instance created");
        try {
            InetAddress addr = InetAddress.getLocalHost();
            this.init(addr.isLoopbackAddress() ? null : addr, addr.getHostName());
        }
        catch (IOException e) {
            this.init(null, "computer");
        }
    }

    public JmDNS(InetAddress addr) throws IOException {
        this.init(addr, addr.getHostName());
    }

    private void init(InetAddress address, String name) throws IOException {
        int idx = name.indexOf(".");
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        name = name + ".local.";
        this.localHost = new HostInfo(address, name);
        this.cache = new DNSCache(100);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.serviceListeners = new HashMap();
        this.typeListeners = new ArrayList();
        this.services = new Hashtable(20);
        this.serviceTypes = new Hashtable(20);
        this.timer = new Timer();
        new RecordReaper().start();
        this.shutdown = new Thread((Runnable)new Shutdown(), "JmDNS.Shutdown");
        Runtime.getRuntime().addShutdownHook(this.shutdown);
        this.incomingListener = new Thread((Runnable)new SocketListener(), "JmDNS.SocketListener");
        this.openMulticastSocket(this.localHost);
        this.start(this.services);
    }

    private void start(Map services) {
        this.state = DNSState.PROBING_1;
        this.incomingListener.start();
        new Prober().start();
        Iterator iterator = services.values().iterator();
        while (iterator.hasNext()) {
            try {
                this.registerService(new ServiceInfo((ServiceInfo)iterator.next()));
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "start() Registration exception ", exception);
            }
        }
    }

    private void openMulticastSocket(HostInfo HostInfo2) throws IOException {
        if (this.group == null) {
            this.group = InetAddress.getByName("224.0.0.251");
        }
        if (this.socket != null) {
            this.closeMulticastSocket();
        }
        this.socket = new MulticastSocket(5353);
        if (this.localHost.getInterface() != null) {
            this.socket.setNetworkInterface(this.localHost.getInterface());
        }
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
    }

    private void closeMulticastSocket() {
        logger.finer("closeMulticastSocket()");
        if (this.socket != null) {
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
                if (this.incomingListener != null) {
                    this.incomingListener.join();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "closeMulticastSocket() Close socket exception ", exception);
            }
            this.socket = null;
        }
    }

    synchronized void advanceState() {
        this.state = this.state.advance();
        this.notifyAll();
    }

    synchronized void revertState() {
        this.state = this.state.revert();
        this.notifyAll();
    }

    synchronized void cancel() {
        this.state = DNSState.CANCELED;
        this.notifyAll();
    }

    DNSState getState() {
        return this.state;
    }

    DNSCache getCache() {
        return this.cache;
    }

    public String getHostName() {
        return this.localHost.getName();
    }

    public HostInfo getLocalHost() {
        return this.localHost;
    }

    public InetAddress getInterface() throws IOException {
        return this.socket.getInterface();
    }

    public ServiceInfo getServiceInfo(String type, String name) {
        return this.getServiceInfo(type, name, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getServiceInfo(String type, String name, int timeout) {
        ServiceInfo info = new ServiceInfo(type, name);
        new ServiceInfoResolver(info).start();
        try {
            long end = System.currentTimeMillis() + (long)timeout;
            ServiceInfo serviceInfo = info;
            synchronized (serviceInfo) {
                long delay;
                while (!info.hasData() && (delay = end - System.currentTimeMillis()) > 0L) {
                    info.wait(delay);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return info.hasData() ? info : null;
    }

    public void requestServiceInfo(String type, String name) {
        this.requestServiceInfo(type, name, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestServiceInfo(String type, String name, int timeout) {
        this.registerServiceType(type);
        ServiceInfo info = new ServiceInfo(type, name);
        new ServiceInfoResolver(info).start();
        try {
            long end = System.currentTimeMillis() + (long)timeout;
            ServiceInfo serviceInfo = info;
            synchronized (serviceInfo) {
                long delay;
                while (!info.hasData() && (delay = end - System.currentTimeMillis()) > 0L) {
                    info.wait(delay);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    void handleServiceResolved(ServiceInfo info) {
        List list = (List)this.serviceListeners.get(info.type.toLowerCase());
        if (list != null) {
            ServiceEvent event = new ServiceEvent(this, info.type, info.getName(), info);
            ArrayList listCopy = new ArrayList(list);
            Iterator iterator = listCopy.iterator();
            while (iterator.hasNext()) {
                ((ServiceListener)iterator.next()).serviceResolved(event);
            }
        }
    }

    public void addServiceTypeListener(ServiceTypeListener listener) throws IOException {
        this.removeServiceTypeListener(listener);
        this.typeListeners.add(listener);
        Iterator iterator = this.serviceTypes.values().iterator();
        while (iterator.hasNext()) {
            listener.serviceTypeAdded(new ServiceEvent(this, (String)iterator.next(), null, null));
        }
        new TypeResolver().start();
    }

    public void removeServiceTypeListener(ServiceTypeListener listener) {
        this.typeListeners.remove(listener);
    }

    public void addServiceListener(String type, ServiceListener listener) {
        String lotype = type.toLowerCase();
        this.removeServiceListener(lotype, listener);
        List<ServiceListener> list = (List<ServiceListener>)this.serviceListeners.get(lotype);
        if (list == null) {
            list = Collections.synchronizedList(new LinkedList());
            this.serviceListeners.put(lotype, list);
        }
        list.add(listener);
        Iterator i = this.cache.iterator();
        while (i.hasNext()) {
            for (DNSCache.CacheNode n = (DNSCache.CacheNode)i.next(); n != null; n = n.next()) {
                DNSRecord rec = (DNSRecord)n.getValue();
                if (rec.type != 33 || !rec.name.endsWith(type)) continue;
                listener.serviceAdded(new ServiceEvent(this, type, JmDNS.toUnqualifiedName(type, rec.name), null));
            }
        }
        new ServiceResolver(type).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String type, ServiceListener listener) {
        List list = (List)this.serviceListeners.get(type = type.toLowerCase());
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                list.remove(listener);
                if (list.size() == 0) {
                    this.serviceListeners.remove(type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceInfo info) throws IOException {
        this.registerServiceType(info.type);
        info.server = this.localHost.getName();
        info.addr = this.localHost.getAddress();
        this.makeServiceNameUnique(info);
        this.services.put(info.getQualifiedName().toLowerCase(), info);
        new Prober().start();
        try {
            ServiceInfo serviceInfo = info;
            synchronized (serviceInfo) {
                while (info.getState().compareTo(DNSState.ANNOUNCED) < 0) {
                    info.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.fine("registerService() JmDNS registered service as " + info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterService(ServiceInfo info) {
        this.services.remove(info.getQualifiedName().toLowerCase());
        info.cancel();
        Object lock = new Object();
        new Canceler(info, lock).start();
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterAllServices() {
        if (this.services.size() == 0) {
            return;
        }
        ServiceInfo[] infos = this.services.values().toArray(new ServiceInfo[this.services.size()]);
        this.services.clear();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].cancel();
        }
        Object lock = new Object();
        new Canceler(infos, lock).start();
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void registerServiceType(String type) {
        String name = type.toLowerCase();
        if (this.serviceTypes.get(name) == null && type.indexOf("._mdns._udp.") < 0 && !type.endsWith(".in-addr.arpa.")) {
            this.serviceTypes.put(name, type);
            Iterator iterator = this.typeListeners.iterator();
            while (iterator.hasNext()) {
                ((ServiceTypeListener)iterator.next()).serviceTypeAdded(new ServiceEvent(this, type, null, null));
            }
        }
    }

    private boolean makeHostNameUnique(DNSRecord.Address host) {
        boolean collision;
        String originalName = host.getName();
        long now = System.currentTimeMillis();
        do {
            collision = false;
            for (DNSCache.CacheNode j = this.cache.find(host.getName().toLowerCase()); j != null; j = j.next()) {
                DNSRecord a = (DNSRecord)j.getValue();
            }
        } while (collision);
        return !originalName.equals(host.getName());
    }

    private boolean makeServiceNameUnique(ServiceInfo info) {
        boolean collision;
        String originalQualifiedName = info.getQualifiedName();
        long now = System.currentTimeMillis();
        do {
            Object selfService;
            collision = false;
            for (DNSCache.CacheNode j = this.cache.find(info.getQualifiedName().toLowerCase()); j != null; j = j.next()) {
                DNSRecord a = (DNSRecord)j.getValue();
                if (a.type != 33 || a.isExpired(now)) continue;
                DNSRecord.Service s = (DNSRecord.Service)a;
                if (s.port == info.port && s.server.equals(this.localHost.getName())) continue;
                logger.finer("makeServiceNameUnique() JmDNS.makeServiceNameUnique srv collision:" + a + " s.server=" + s.server + " " + this.localHost.getName() + " equals:" + s.server.equals(this.localHost.getName()));
                info.setName(this.incrementName(info.getName()));
                collision = true;
                break;
            }
            if ((selfService = this.services.get(info.getQualifiedName().toLowerCase())) == null || selfService == info) continue;
            info.setName(this.incrementName(info.getName()));
            collision = true;
        } while (collision);
        return !originalQualifiedName.equals(info.getQualifiedName());
    }

    String incrementName(String name) {
        try {
            int l = name.lastIndexOf(40);
            int r = name.lastIndexOf(41);
            name = l >= 0 && l < r ? name.substring(0, l) + "(" + (Integer.parseInt(name.substring(l + 1, r)) + 1) + ")" : name + " (2)";
        }
        catch (NumberFormatException e) {
            name = name + " (2)";
        }
        return name;
    }

    void addListener(DNSListener listener, DNSQuestion question) {
        long now = System.currentTimeMillis();
        this.listeners.add(listener);
        if (question != null) {
            for (DNSCache.CacheNode i = this.cache.find(question.name); i != null; i = i.next()) {
                DNSRecord c = (DNSRecord)i.getValue();
                if (!question.answeredBy(c) || c.isExpired(now)) continue;
                listener.updateRecord(this, now, c);
            }
        }
    }

    void removeListener(DNSListener listener) {
        this.listeners.remove(listener);
    }

    void updateRecord(long now, DNSRecord rec) {
        block5: {
            List list;
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                DNSListener listener = (DNSListener)iterator.next();
                listener.updateRecord(this, now, rec);
            }
            if (rec.type != 12 && rec.type != 33 || (list = (List)this.serviceListeners.get(rec.name.toLowerCase())) == null) break block5;
            boolean expired = rec.isExpired(now);
            String type = rec.getName();
            String name = ((DNSRecord.Pointer)rec).getAlias();
            if (!expired) {
                ServiceEvent event = new ServiceEvent(this, type, JmDNS.toUnqualifiedName(type, name), null);
                ArrayList listCopy = new ArrayList(list);
                Iterator iterator2 = listCopy.iterator();
                while (iterator2.hasNext()) {
                    ((ServiceListener)iterator2.next()).serviceAdded(event);
                }
            } else {
                ServiceEvent event = new ServiceEvent(this, type, JmDNS.toUnqualifiedName(type, name), null);
                ArrayList listCopy = new ArrayList(list);
                Iterator iterator3 = listCopy.iterator();
                while (iterator3.hasNext()) {
                    ((ServiceListener)iterator3.next()).serviceRemoved(event);
                }
            }
        }
    }

    private void handleResponse(DNSIncoming msg) throws IOException {
        long now = System.currentTimeMillis();
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        Iterator e = msg.answers.iterator();
        block3: while (e.hasNext()) {
            boolean isInformative = false;
            DNSRecord rec = (DNSRecord)e.next();
            boolean expired = rec.isExpired(now);
            DNSRecord c = (DNSRecord)this.cache.get(rec);
            if (c != null) {
                if (expired) {
                    isInformative = true;
                    this.cache.remove(c);
                } else {
                    c.resetTTL(rec);
                    rec = c;
                }
            } else if (!expired) {
                isInformative = true;
                this.cache.add(rec);
            }
            switch (rec.type) {
                case 12: {
                    if (rec.getName().indexOf("._mdns._udp.") >= 0) {
                        if (expired || !rec.name.startsWith("_services._mdns._udp.")) continue block3;
                        isInformative = true;
                        this.registerServiceType(((DNSRecord.Pointer)rec).alias);
                        continue block3;
                    }
                    this.registerServiceType(rec.name);
                }
            }
            if (rec.getType() == 1 || rec.getType() == 28) {
                hostConflictDetected |= rec.handleResponse(this);
            } else {
                serviceConflictDetected |= rec.handleResponse(this);
            }
            if (!isInformative) continue;
            this.updateRecord(now, rec);
        }
        if (hostConflictDetected || serviceConflictDetected) {
            new Prober().start();
        }
    }

    private void handleQuery(DNSIncoming in, InetAddress addr, int port) throws IOException {
        boolean hostConflictDetected = false;
        boolean serviceConflictDetected = false;
        long expirationTime = System.currentTimeMillis() + 120L;
        Iterator i = in.answers.iterator();
        while (i.hasNext()) {
            DNSRecord answer = (DNSRecord)i.next();
            if (answer.getType() == 1 || answer.getType() == 28) {
                hostConflictDetected |= answer.handleQuery(this, expirationTime);
                continue;
            }
            serviceConflictDetected |= answer.handleQuery(this, expirationTime);
        }
        if (this.plannedAnswer != null) {
            this.plannedAnswer.append(in);
        } else {
            if (in.isTruncated()) {
                this.plannedAnswer = in;
            }
            new Responder(in, addr, port).start();
        }
        if (hostConflictDetected || serviceConflictDetected) {
            new Prober().start();
        }
    }

    DNSOutgoing addAnswer(DNSIncoming in, InetAddress addr, int port, DNSOutgoing out, DNSRecord rec) throws IOException {
        if (out == null) {
            out = new DNSOutgoing(33792);
        }
        try {
            out.addAnswer(in, rec);
        }
        catch (IOException e) {
            out.flags |= 0x200;
            out.id = in.id;
            out.finish();
            this.send(out);
            out = new DNSOutgoing(33792);
            out.addAnswer(in, rec);
        }
        return out;
    }

    private void send(DNSOutgoing out) throws IOException {
        out.finish();
        if (!out.isEmpty()) {
            DatagramPacket packet = new DatagramPacket(out.data, out.off, this.group, 5353);
            try {
                DNSIncoming msg = new DNSIncoming(packet);
                logger.finest("send() JmDNS out:" + msg.print(true));
            }
            catch (IOException e) {
                logger.throwing(this.getClass().toString(), "send(DNSOutgoing) - JmDNS can not parse what it sends!!!", e);
            }
            this.socket.send(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recover() {
        if (DNSState.CANCELED != this.state) {
            JmDNS jmDNS = this;
            synchronized (jmDNS) {
                logger.finer("recover()");
                this.state = DNSState.CANCELED;
                Map oldServices = (Map)this.services.clone();
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.cache.clear();
                try {
                    this.openMulticastSocket(this.localHost);
                    this.start(oldServices);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "recover() Start services exception ", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.state != DNSState.CANCELED) {
            JmDNS jmDNS = this;
            synchronized (jmDNS) {
                this.state = DNSState.CANCELED;
                this.unregisterAllServices();
                this.disposeServiceCollectors();
                this.closeMulticastSocket();
                this.timer.cancel();
                if (this.shutdown != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdown);
                }
            }
        }
    }

    void print() {
        System.out.println("---- cache ----");
        this.cache.print();
        System.out.println();
    }

    public void printServices() {
        System.err.println(this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object key;
        Iterator k;
        StringBuffer aLog = new StringBuffer();
        aLog.append("\t---- Services -----");
        if (this.services != null) {
            k = this.services.keySet().iterator();
            while (k.hasNext()) {
                key = k.next();
                aLog.append("\n\t\tService: " + key + ": " + this.services.get(key));
            }
        }
        aLog.append("\n");
        aLog.append("\t---- Types ----");
        if (this.serviceTypes != null) {
            k = this.serviceTypes.keySet().iterator();
            while (k.hasNext()) {
                key = k.next();
                aLog.append("\n\t\tType: " + key + ": " + this.serviceTypes.get(key));
            }
        }
        aLog.append("\n");
        aLog.append(this.cache.toString());
        aLog.append("\n");
        aLog.append("\t---- Service Collectors ----");
        if (this.serviceCollectors != null) {
            HashMap hashMap = this.serviceCollectors;
            synchronized (hashMap) {
                Iterator k2 = this.serviceCollectors.keySet().iterator();
                while (k2.hasNext()) {
                    Object key2 = k2.next();
                    aLog.append("\n\t\tService Collector: " + key2 + ": " + this.serviceCollectors.get(key2));
                }
                this.serviceCollectors.clear();
            }
        }
        return aLog.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo[] list(String type) {
        boolean newCollectorCreated;
        ServiceCollector collector;
        HashMap hashMap = this.serviceCollectors;
        synchronized (hashMap) {
            collector = (ServiceCollector)this.serviceCollectors.get(type);
            if (collector == null) {
                collector = new ServiceCollector(type);
                this.serviceCollectors.put(type, collector);
                this.addServiceListener(type, collector);
                newCollectorCreated = true;
            } else {
                newCollectorCreated = false;
            }
        }
        if (newCollectorCreated) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return collector.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeServiceCollectors() {
        HashMap hashMap = this.serviceCollectors;
        synchronized (hashMap) {
            Iterator i = this.serviceCollectors.values().iterator();
            while (i.hasNext()) {
                ServiceCollector collector = (ServiceCollector)i.next();
                this.removeServiceListener(collector.type, collector);
            }
            this.serviceCollectors.clear();
        }
    }

    private static String toUnqualifiedName(String type, String qualifiedName) {
        if (qualifiedName.endsWith(type)) {
            return qualifiedName.substring(0, qualifiedName.length() - type.length() - 1);
        }
        return qualifiedName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ServiceCollector
    implements ServiceListener {
        private static Logger logger = Logger.getLogger((class$javax$jmdns$JmDNS$ServiceCollector == null ? (class$javax$jmdns$JmDNS$ServiceCollector = JmDNS.class$("javax.jmdns.JmDNS$ServiceCollector")) : class$javax$jmdns$JmDNS$ServiceCollector).toString());
        private Map infos = Collections.synchronizedMap(new HashMap());
        public String type;

        public ServiceCollector(String type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceAdded(ServiceEvent event) {
            Map map = this.infos;
            synchronized (map) {
                event.getDNS().requestServiceInfo(event.getType(), event.getName(), 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceEvent event) {
            Map map = this.infos;
            synchronized (map) {
                this.infos.remove(event.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceResolved(ServiceEvent event) {
            Map map = this.infos;
            synchronized (map) {
                this.infos.put(event.getName(), event.getInfo());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceInfo[] list() {
            Map map = this.infos;
            synchronized (map) {
                return this.infos.values().toArray(new ServiceInfo[this.infos.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer aLog = new StringBuffer();
            Map map = this.infos;
            synchronized (map) {
                Iterator k = this.infos.keySet().iterator();
                while (k.hasNext()) {
                    Object key = k.next();
                    aLog.append("\n\t\tService: " + key + ": " + this.infos.get(key));
                }
            }
            return aLog.toString();
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            JmDNS.this.shutdown = null;
            JmDNS.this.close();
        }
    }

    private class Canceler
    extends TimerTask {
        int count = 0;
        private ServiceInfo[] infos;
        private Object lock;
        int ttl = 0;

        public Canceler(ServiceInfo info, Object lock) {
            this.infos = new ServiceInfo[]{info};
            this.lock = lock;
            JmDNS.this.addListener(info, new DNSQuestion(info.getQualifiedName(), 255, 1));
        }

        public Canceler(ServiceInfo[] infos, Object lock) {
            this.infos = infos;
            this.lock = lock;
        }

        public Canceler(Collection infos) {
            this.infos = infos.toArray(new ServiceInfo[infos.size()]);
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 0L, 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    if (++this.count < 3) {
                        logger.finer("run() JmDNS canceling service");
                        DNSOutgoing out = new DNSOutgoing(33792);
                        for (int i = 0; i < this.infos.length; ++i) {
                            ServiceInfo info = this.infos[i];
                            out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, this.ttl, info.getQualifiedName()), 0L);
                            out.addAnswer(new DNSRecord.Service(info.getQualifiedName(), 33, 1, this.ttl, info.priority, info.weight, info.port, JmDNS.this.localHost.getName()), 0L);
                            out.addAnswer(new DNSRecord.Text(info.getQualifiedName(), 16, 1, this.ttl, info.text), 0L);
                            DNSRecord.Address answer = JmDNS.this.localHost.getDNS4AddressRecord();
                            if (answer != null) {
                                out.addAnswer(answer, 0L);
                            }
                            if ((answer = JmDNS.this.localHost.getDNS6AddressRecord()) == null) continue;
                            out.addAnswer(answer, 0L);
                        }
                        JmDNS.this.send(out);
                        break block8;
                    }
                    Object out = this.lock;
                    synchronized (out) {
                        this.lock.notifyAll();
                    }
                    this.cancel();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "run() exception ", e);
                    JmDNS.this.recover();
                }
            }
        }
    }

    private class ServiceInfoResolver
    extends TimerTask {
        int count = 0;
        private ServiceInfo info;

        public ServiceInfoResolver(ServiceInfo info) {
            this.info = info;
            info.dns = JmDNS.this;
            JmDNS.this.addListener(info, new DNSQuestion(info.getQualifiedName(), 255, 1));
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 225L, 225L);
        }

        public void run() {
            try {
                if (JmDNS.this.state == DNSState.ANNOUNCED) {
                    if (this.count++ < 3 && !this.info.hasData()) {
                        long now = System.currentTimeMillis();
                        DNSOutgoing out = new DNSOutgoing(0);
                        out.addQuestion(new DNSQuestion(this.info.getQualifiedName(), 33, 1));
                        out.addQuestion(new DNSQuestion(this.info.getQualifiedName(), 16, 1));
                        if (this.info.server != null) {
                            out.addQuestion(new DNSQuestion(this.info.server, 1, 1));
                        }
                        out.addAnswer((DNSRecord)JmDNS.this.cache.get(this.info.getQualifiedName(), 33, 1), now);
                        out.addAnswer((DNSRecord)JmDNS.this.cache.get(this.info.getQualifiedName(), 16, 1), now);
                        if (this.info.server != null) {
                            out.addAnswer((DNSRecord)JmDNS.this.cache.get(this.info.server, 1, 1), now);
                        }
                        JmDNS.this.send(out);
                    } else {
                        this.cancel();
                        JmDNS.this.removeListener(this.info);
                    }
                } else if (JmDNS.this.state == DNSState.CANCELED) {
                    this.cancel();
                    JmDNS.this.removeListener(this.info);
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "run() exception ", e);
                JmDNS.this.recover();
            }
        }
    }

    private class ServiceResolver
    extends TimerTask {
        int count = 0;
        private String type;

        public ServiceResolver(String type) {
            this.type = type;
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 225L, 225L);
        }

        public void run() {
            try {
                if (JmDNS.this.state == DNSState.ANNOUNCED) {
                    if (this.count++ < 3) {
                        logger.finer("run() JmDNS querying service");
                        long now = System.currentTimeMillis();
                        DNSOutgoing out = new DNSOutgoing(0);
                        out.addQuestion(new DNSQuestion(this.type, 12, 1));
                        Enumeration e = JmDNS.this.services.elements();
                        while (e.hasMoreElements()) {
                            ServiceInfo info = (ServiceInfo)e.nextElement();
                            try {
                                out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.getQualifiedName()), now);
                            }
                            catch (IOException ee) {
                                break;
                            }
                        }
                        JmDNS.this.send(out);
                    } else {
                        this.cancel();
                    }
                } else if (JmDNS.this.state == DNSState.CANCELED) {
                    this.cancel();
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "run() exception ", e);
                JmDNS.this.recover();
            }
        }
    }

    private class TypeResolver
    extends TimerTask {
        int count = 0;

        private TypeResolver() {
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 225L, 225L);
        }

        public void run() {
            try {
                if (JmDNS.this.state == DNSState.ANNOUNCED) {
                    if (++this.count < 3) {
                        logger.finer("run() JmDNS querying type");
                        DNSOutgoing out = new DNSOutgoing(0);
                        out.addQuestion(new DNSQuestion("_services._mdns._udp.local.", 12, 1));
                        Iterator iterator = JmDNS.this.serviceTypes.values().iterator();
                        while (iterator.hasNext()) {
                            out.addAnswer(new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)iterator.next()), 0L);
                        }
                        JmDNS.this.send(out);
                    } else {
                        this.cancel();
                    }
                } else if (JmDNS.this.state == DNSState.CANCELED) {
                    this.cancel();
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "run() exception ", e);
                JmDNS.this.recover();
            }
        }
    }

    private class Responder
    extends TimerTask {
        private DNSIncoming in;
        private InetAddress addr;
        private int port;

        public Responder(DNSIncoming in, InetAddress addr, int port) {
            this.in = in;
            this.addr = addr;
            this.port = port;
        }

        public void start() {
            int delay;
            boolean iAmTheOnlyOne = true;
            Iterator i = this.in.questions.iterator();
            while (i.hasNext()) {
                DNSEntry entry = (DNSEntry)i.next();
                if (!(entry instanceof DNSQuestion)) continue;
                DNSQuestion q = (DNSQuestion)entry;
                logger.finest("start() question=" + q);
                if (iAmTheOnlyOne &= q.type == 33 || q.type == 16 || q.type == 1 || q.type == 28 || JmDNS.this.localHost.getName().equalsIgnoreCase(q.name) || JmDNS.this.services.containsKey(q.name.toLowerCase())) continue;
                break;
            }
            int n = delay = iAmTheOnlyOne && !this.in.isTruncated() ? 0 : 20 + random.nextInt(96) - this.in.elapseSinceArrival();
            if (delay < 0) {
                delay = 0;
            }
            logger.finest("start() Responder chosen delay=" + delay);
            JmDNS.this.timer.schedule((TimerTask)this, delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = JmDNS.this.ioLock;
            synchronized (object) {
                if (JmDNS.this.plannedAnswer == this.in) {
                    JmDNS.this.plannedAnswer = null;
                }
                HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
                HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
                if (JmDNS.this.state == DNSState.ANNOUNCED) {
                    try {
                        long now = System.currentTimeMillis();
                        long expirationTime = now + 1L;
                        boolean isUnicast = this.port != 5353;
                        Iterator iterator = this.in.questions.iterator();
                        block11: while (iterator.hasNext()) {
                            DNSRecord.Address answer;
                            int type;
                            DNSEntry entry = (DNSEntry)iterator.next();
                            if (!(entry instanceof DNSQuestion)) continue;
                            DNSQuestion q = (DNSQuestion)entry;
                            if (isUnicast) {
                                questions.add(q);
                            }
                            if ((type = q.type) == 255 || type == 33) {
                                if (JmDNS.this.localHost.getName().equalsIgnoreCase(q.getName())) {
                                    answer = JmDNS.this.localHost.getDNS4AddressRecord();
                                    if (answer != null) {
                                        answers.add(answer);
                                    }
                                    if ((answer = JmDNS.this.localHost.getDNS6AddressRecord()) != null) {
                                        answers.add(answer);
                                    }
                                    type = 0;
                                } else if (JmDNS.this.serviceTypes.containsKey(q.getName().toLowerCase())) {
                                    type = 12;
                                }
                            }
                            switch (type) {
                                case 1: {
                                    answer = JmDNS.this.localHost.getDNS4AddressRecord();
                                    if (answer == null) break;
                                    answers.add(answer);
                                    break;
                                }
                                case 28: {
                                    answer = JmDNS.this.localHost.getDNS6AddressRecord();
                                    if (answer == null) break;
                                    answers.add(answer);
                                    break;
                                }
                                case 12: {
                                    Iterator serviceIterator = JmDNS.this.services.values().iterator();
                                    while (serviceIterator.hasNext()) {
                                        ServiceInfo info = (ServiceInfo)serviceIterator.next();
                                        if (info.getState() != DNSState.ANNOUNCED || !q.name.equalsIgnoreCase(info.type)) continue;
                                        DNSRecord.Address answer2 = JmDNS.this.localHost.getDNS4AddressRecord();
                                        if (answer2 != null) {
                                            answers.add(answer2);
                                        }
                                        if ((answer2 = JmDNS.this.localHost.getDNS6AddressRecord()) != null) {
                                            answers.add(answer2);
                                        }
                                        answers.add(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.getQualifiedName()));
                                        answers.add(new DNSRecord.Service(info.getQualifiedName(), 33, 32769, 3600, info.priority, info.weight, info.port, JmDNS.this.localHost.getName()));
                                        answers.add(new DNSRecord.Text(info.getQualifiedName(), 16, 32769, 3600, info.text));
                                    }
                                    if (!q.name.equalsIgnoreCase("_services._mdns._udp.local.")) break;
                                    Iterator serviceTypeIterator = JmDNS.this.serviceTypes.values().iterator();
                                    while (serviceTypeIterator.hasNext()) {
                                        answers.add(new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)serviceTypeIterator.next()));
                                    }
                                    continue block11;
                                }
                                case 16: 
                                case 33: 
                                case 255: {
                                    ServiceInfo info = (ServiceInfo)JmDNS.this.services.get(q.name.toLowerCase());
                                    if (info == null || info.getState() != DNSState.ANNOUNCED) break;
                                    DNSRecord.Address answer3 = JmDNS.this.localHost.getDNS4AddressRecord();
                                    if (answer3 != null) {
                                        answers.add(answer3);
                                    }
                                    if ((answer3 = JmDNS.this.localHost.getDNS6AddressRecord()) != null) {
                                        answers.add(answer3);
                                    }
                                    answers.add(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.getQualifiedName()));
                                    answers.add(new DNSRecord.Service(info.getQualifiedName(), 33, 32769, 3600, info.priority, info.weight, info.port, JmDNS.this.localHost.getName()));
                                    answers.add(new DNSRecord.Text(info.getQualifiedName(), 16, 32769, 3600, info.text));
                                    break;
                                }
                            }
                        }
                        Iterator i = this.in.answers.iterator();
                        while (i.hasNext()) {
                            DNSRecord knownAnswer = (DNSRecord)i.next();
                            if (knownAnswer.ttl <= 1800 || !answers.remove(knownAnswer)) continue;
                            logger.log(Level.FINER, "JmDNS Responder Known Answer Removed");
                        }
                        if (answers.size() != 0) {
                            logger.finer("run() JmDNS responding");
                            DNSOutgoing out = null;
                            if (isUnicast) {
                                out = new DNSOutgoing(33792, false);
                            }
                            Iterator i2 = questions.iterator();
                            while (i2.hasNext()) {
                                out.addQuestion((DNSQuestion)i2.next());
                            }
                            i2 = answers.iterator();
                            while (i2.hasNext()) {
                                out = JmDNS.this.addAnswer(this.in, this.addr, this.port, out, (DNSRecord)i2.next());
                            }
                            JmDNS.this.send(out);
                        }
                        this.cancel();
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "run() exception ", e);
                        JmDNS.this.close();
                    }
                }
            }
        }
    }

    private class Renewer
    extends TimerTask {
        DNSState taskState = DNSState.ANNOUNCED;

        public Renewer() {
            if (JmDNS.this.state == DNSState.ANNOUNCED) {
                JmDNS.this.task = this;
            }
            Enumeration s = JmDNS.this.services.elements();
            while (s.hasMoreElements()) {
                ServiceInfo info = (ServiceInfo)s.nextElement();
                if (info.getState() != DNSState.ANNOUNCED) continue;
                info.task = this;
            }
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 2880000L, 2880000L);
        }

        public boolean cancel() {
            if (JmDNS.this.task == this) {
                JmDNS.this.task = null;
            }
            Iterator i = JmDNS.this.services.values().iterator();
            while (i.hasNext()) {
                ServiceInfo info = (ServiceInfo)i.next();
                if (info.task != this) continue;
                info.task = null;
            }
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DNSOutgoing out = null;
            try {
                ArrayList list;
                if (JmDNS.this.state == this.taskState) {
                    DNSRecord.Address answer;
                    if (out == null) {
                        out = new DNSOutgoing(33792);
                    }
                    if ((answer = JmDNS.this.localHost.getDNS4AddressRecord()) != null) {
                        out.addAnswer(answer, 0L);
                    }
                    if ((answer = JmDNS.this.localHost.getDNS6AddressRecord()) != null) {
                        out.addAnswer(answer, 0L);
                    }
                    JmDNS.this.advanceState();
                }
                JmDNS jmDNS = JmDNS.this;
                synchronized (jmDNS) {
                    list = new ArrayList(JmDNS.this.services.values());
                }
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    ServiceInfo info;
                    ServiceInfo serviceInfo = info = (ServiceInfo)i.next();
                    synchronized (serviceInfo) {
                        if (info.getState() == this.taskState && info.task == this) {
                            info.advanceState();
                            logger.finer("run() JmDNS announced " + info.getQualifiedName() + " state " + info.getState());
                            if (out == null) {
                                out = new DNSOutgoing(33792);
                            }
                            out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.getQualifiedName()), 0L);
                            out.addAnswer(new DNSRecord.Service(info.getQualifiedName(), 33, 1, 3600, info.priority, info.weight, info.port, JmDNS.this.localHost.getName()), 0L);
                            out.addAnswer(new DNSRecord.Text(info.getQualifiedName(), 16, 1, 3600, info.text), 0L);
                        }
                    }
                }
                if (out != null) {
                    logger.finer("run() JmDNS announced");
                    JmDNS.this.send(out);
                } else {
                    this.cancel();
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "run() exception ", e);
                JmDNS.this.recover();
            }
            this.taskState = this.taskState.advance();
            if (!this.taskState.isAnnounced()) {
                this.cancel();
            }
        }
    }

    private class Announcer
    extends TimerTask {
        DNSState taskState = DNSState.ANNOUNCING_1;

        public Announcer() {
            if (JmDNS.this.state == DNSState.ANNOUNCING_1) {
                JmDNS.this.task = this;
            }
            Enumeration s = JmDNS.this.services.elements();
            while (s.hasMoreElements()) {
                ServiceInfo info = (ServiceInfo)s.nextElement();
                if (info.getState() != DNSState.ANNOUNCING_1) continue;
                info.task = this;
            }
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 1000L, 1000L);
        }

        public boolean cancel() {
            if (JmDNS.this.task == this) {
                JmDNS.this.task = null;
            }
            Iterator i = JmDNS.this.services.values().iterator();
            while (i.hasNext()) {
                ServiceInfo info = (ServiceInfo)i.next();
                if (info.task != this) continue;
                info.task = null;
            }
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DNSOutgoing out = null;
            try {
                ArrayList list;
                if (JmDNS.this.state == this.taskState) {
                    DNSRecord.Address answer;
                    if (out == null) {
                        out = new DNSOutgoing(33792);
                    }
                    if ((answer = JmDNS.this.localHost.getDNS4AddressRecord()) != null) {
                        out.addAnswer(answer, 0L);
                    }
                    if ((answer = JmDNS.this.localHost.getDNS6AddressRecord()) != null) {
                        out.addAnswer(answer, 0L);
                    }
                    JmDNS.this.advanceState();
                }
                JmDNS jmDNS = JmDNS.this;
                synchronized (jmDNS) {
                    list = new ArrayList(JmDNS.this.services.values());
                }
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    ServiceInfo info;
                    ServiceInfo serviceInfo = info = (ServiceInfo)i.next();
                    synchronized (serviceInfo) {
                        if (info.getState() == this.taskState && info.task == this) {
                            info.advanceState();
                            logger.finer("run() JmDNS announcing " + info.getQualifiedName() + " state " + info.getState());
                            if (out == null) {
                                out = new DNSOutgoing(33792);
                            }
                            out.addAnswer(new DNSRecord.Pointer(info.type, 12, 1, 3600, info.getQualifiedName()), 0L);
                            out.addAnswer(new DNSRecord.Service(info.getQualifiedName(), 33, 1, 3600, info.priority, info.weight, info.port, JmDNS.this.localHost.getName()), 0L);
                            out.addAnswer(new DNSRecord.Text(info.getQualifiedName(), 16, 1, 3600, info.text), 0L);
                        }
                    }
                }
                if (out != null) {
                    logger.finer("run() JmDNS announcing #" + this.taskState);
                    JmDNS.this.send(out);
                } else {
                    this.cancel();
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "run() exception ", e);
                JmDNS.this.recover();
            }
            this.taskState = this.taskState.advance();
            if (!this.taskState.isAnnouncing()) {
                this.cancel();
                new Renewer().start();
            }
        }
    }

    private class Prober
    extends TimerTask {
        DNSState taskState = DNSState.PROBING_1;

        public Prober() {
            if (JmDNS.this.state == DNSState.PROBING_1) {
                JmDNS.this.task = this;
            }
            Iterator iterator = JmDNS.this.services.values().iterator();
            while (iterator.hasNext()) {
                ServiceInfo info = (ServiceInfo)iterator.next();
                if (info.getState() != DNSState.PROBING_1) continue;
                info.task = this;
            }
        }

        public void start() {
            long now = System.currentTimeMillis();
            if (now - JmDNS.this.lastThrottleIncrement < 5000L) {
                JmDNS.this.throttle++;
            } else {
                JmDNS.this.throttle = 1;
            }
            JmDNS.this.lastThrottleIncrement = now;
            if (JmDNS.this.state == DNSState.ANNOUNCED && JmDNS.this.throttle < 10) {
                JmDNS.this.timer.schedule((TimerTask)this, random.nextInt(251), 250L);
            } else {
                JmDNS.this.timer.schedule((TimerTask)this, 1000L, 1000L);
            }
        }

        public boolean cancel() {
            if (JmDNS.this.task == this) {
                JmDNS.this.task = null;
            }
            Iterator i = JmDNS.this.services.values().iterator();
            while (i.hasNext()) {
                ServiceInfo info = (ServiceInfo)i.next();
                if (info.task != this) continue;
                info.task = null;
            }
            return super.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = JmDNS.this.ioLock;
            synchronized (object) {
                DNSOutgoing out = null;
                try {
                    LinkedList list;
                    if (JmDNS.this.state == this.taskState && JmDNS.this.task == this) {
                        if (out == null) {
                            out = new DNSOutgoing(0);
                        }
                        out.addQuestion(new DNSQuestion(JmDNS.this.localHost.getName(), 255, 1));
                        DNSRecord.Address answer = JmDNS.this.localHost.getDNS4AddressRecord();
                        if (answer != null) {
                            out.addAuthorativeAnswer(answer);
                        }
                        if ((answer = JmDNS.this.localHost.getDNS6AddressRecord()) != null) {
                            out.addAuthorativeAnswer(answer);
                        }
                        JmDNS.this.advanceState();
                    }
                    JmDNS jmDNS = JmDNS.this;
                    synchronized (jmDNS) {
                        list = new LinkedList(JmDNS.this.services.values());
                    }
                    Iterator i = list.iterator();
                    while (i.hasNext()) {
                        ServiceInfo info = (ServiceInfo)i.next();
                        if (info.getState() != this.taskState || info.task != this) continue;
                        info.advanceState();
                        logger.finer("run() JmDNS probing " + info.getQualifiedName() + " state " + info.getState());
                        if (out == null) {
                            out = new DNSOutgoing(0);
                            out.addQuestion(new DNSQuestion(info.getQualifiedName(), 255, 1));
                        }
                        out.addAuthorativeAnswer(new DNSRecord.Service(info.getQualifiedName(), 33, 1, 3600, info.priority, info.weight, info.port, JmDNS.this.localHost.getName()));
                    }
                    if (out == null) {
                        this.cancel();
                        return;
                    }
                    logger.finer("run() JmDNS probing #" + this.taskState);
                    JmDNS.this.send(out);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "run() exception ", e);
                    JmDNS.this.recover();
                }
                this.taskState = this.taskState.advance();
                if (!this.taskState.isProbing()) {
                    this.cancel();
                    new Announcer().start();
                }
            }
        }
    }

    private class RecordReaper
    extends TimerTask {
        private RecordReaper() {
        }

        public void start() {
            JmDNS.this.timer.schedule((TimerTask)this, 10000L, 10000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JmDNS jmDNS = JmDNS.this;
            synchronized (jmDNS) {
                if (JmDNS.this.state == DNSState.CANCELED) {
                    return;
                }
                logger.finest("run() JmDNS reaping cache");
                ArrayList<DNSEntry> list = new ArrayList<DNSEntry>();
                DNSCache dNSCache = JmDNS.this.cache;
                synchronized (dNSCache) {
                    Iterator i = JmDNS.this.cache.iterator();
                    while (i.hasNext()) {
                        for (DNSCache.CacheNode n = (DNSCache.CacheNode)i.next(); n != null; n = n.next()) {
                            list.add(n.getValue());
                        }
                    }
                }
                long now = System.currentTimeMillis();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    DNSRecord c = (DNSRecord)i.next();
                    if (!c.isExpired(now)) continue;
                    JmDNS.this.updateRecord(now, c);
                    JmDNS.this.cache.remove(c);
                }
            }
        }
    }

    class SocketListener
    implements Runnable {
        SocketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block12: {
                try {
                    byte[] buf = new byte[8972];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    while (JmDNS.this.state != DNSState.CANCELED) {
                        packet.setLength(buf.length);
                        JmDNS.this.socket.receive(packet);
                        if (JmDNS.this.state != DNSState.CANCELED) {
                            try {
                                if (JmDNS.this.localHost.shouldIgnorePacket(packet)) continue;
                                DNSIncoming msg = new DNSIncoming(packet);
                                logger.finest("SocketListener.run() JmDNS in:" + msg.print(true));
                                Object object = JmDNS.this.ioLock;
                                synchronized (object) {
                                    if (msg.isQuery()) {
                                        if (packet.getPort() != 5353) {
                                            JmDNS.this.handleQuery(msg, packet.getAddress(), packet.getPort());
                                        }
                                        JmDNS.this.handleQuery(msg, JmDNS.this.group, 5353);
                                    } else {
                                        JmDNS.this.handleResponse(msg);
                                    }
                                    continue;
                                }
                            }
                            catch (IOException e) {
                                logger.log(Level.WARNING, "run() exception ", e);
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    if (JmDNS.this.state == DNSState.CANCELED) break block12;
                    logger.log(Level.WARNING, "run() exception ", e);
                    JmDNS.this.recover();
                }
            }
        }
    }
}

