/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.CanonicalUtils;
import weblogic.xml.babel.stream.ScopeManager;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.util.XMLInputStreamFilterBase;

public class CanonicalInputStream
extends XMLInputStreamFilterBase
implements ElementFilter {
    private ScopeManager namespaces = new ScopeManager();
    private static final SpaceEvent eol = new SpaceEvent("\n");
    private boolean beforeDocumentElement = true;

    public CanonicalInputStream(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.setParent(xMLInputStream);
        this.setFilter(this);
    }

    public boolean accept(XMLEvent xMLEvent) {
        if (!this.namespaces.inRootElement() && (xMLEvent.isSpace() || xMLEvent.isCharacterData() || xMLEvent.isStartDocument() || xMLEvent.isEndDocument())) {
            return false;
        }
        return !xMLEvent.isChangePrefixMapping() && !xMLEvent.isStartPrefixMapping() && !xMLEvent.isEndPrefixMapping();
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return new CanonicalInputStream(this.getParent().getSubStream());
    }

    protected XMLEvent modify(XMLEvent xMLEvent) throws XMLStreamException {
        if (!this.namespaces.inRootElement()) {
            switch (xMLEvent.getType()) {
                case 8: 
                case 32: {
                    if (this.beforeDocumentElement) {
                        this.pushBack((XMLEvent)eol);
                        break;
                    }
                    this.pushBack(xMLEvent);
                    return eol;
                }
            }
        }
        switch (xMLEvent.getType()) {
            case 2: {
                this.beforeDocumentElement = false;
                return this.modify((StartElement)xMLEvent);
            }
            case 4: {
                this.namespaces.closeScope();
                return xMLEvent;
            }
            case 16: {
                return this.modify((CharacterData)xMLEvent);
            }
        }
        return xMLEvent;
    }

    private String checkNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private StartElement modify(StartElement startElement) {
        Attribute attribute;
        this.namespaces.openScope();
        StartElementEvent startElementEvent = new StartElementEvent(startElement.getName());
        startElementEvent.setNamespaceMap(startElement.getNamespaceMap());
        AttributeIterator attributeIterator = CanonicalUtils.sortNamespaces(startElement.getNamespaces());
        while (attributeIterator.hasNext()) {
            attribute = attributeIterator.next();
            this.namespaces.checkPrefixMap(attribute.getName().getLocalName(), attribute.getValue());
            if (!this.namespaces.needToWriteNS(attribute.getName().getLocalName())) continue;
            startElementEvent.addNamespace((Attribute)new AttributeImpl(attribute.getName(), this.checkNull(CanonicalUtils.normalizeCharacters(attribute.getValue(), true)), attribute.getType()));
            this.namespaces.wroteNS(attribute.getName().getLocalName());
        }
        attributeIterator = CanonicalUtils.sortAttributes(startElement.getAttributes());
        while (attributeIterator.hasNext()) {
            attribute = attributeIterator.next();
            startElementEvent.addAttribute((Attribute)new AttributeImpl(attribute.getName(), this.checkNull(CanonicalUtils.normalizeCharacters(attribute.getValue(), true)), attribute.getType()));
        }
        return startElementEvent;
    }

    private CharacterData modify(CharacterData characterData) {
        return new CharacterDataEvent(this.checkNull(CanonicalUtils.normalizeCharacters(characterData.getContent(), false)));
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openValidating(SAXElementFactory.createInputSource(stringArray[0]));
        CanonicalInputStream canonicalInputStream = new CanonicalInputStream(xMLInputStreamBase);
        while (canonicalInputStream.hasNext()) {
            XMLEvent xMLEvent = canonicalInputStream.next();
            System.out.print(xMLEvent);
        }
    }
}

