/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.examples.interpreter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;
import weblogic.xml.babel.examples.interpreter.BooleanInterpreter;
import weblogic.xml.babel.examples.interpreter.VariableExp;
import weblogicx.xml.stream.StartElementEvent;
import weblogicx.xml.stream.XMLEventStream;

public class Context {
    private Map values = new HashMap();
    private String name;

    Context(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean lookup(String string) {
        Boolean bl = (Boolean)this.values.get(string);
        return bl;
    }

    public void assign(VariableExp variableExp, boolean bl) {
        this.values.put(variableExp.getName(), new Boolean(bl));
    }

    private boolean stringToBool(String string) throws SAXException {
        if (string.equals("false")) {
            return false;
        }
        if (string.equals("true")) {
            return true;
        }
        throw new SAXException("Unknown boolean type:" + string);
    }

    public void read(XMLEventStream xMLEventStream) throws SAXException {
        xMLEventStream.startElement();
        while (xMLEventStream.nextElementIs("assign")) {
            StartElementEvent startElementEvent = xMLEventStream.startElement();
            this.assign(new VariableExp(BooleanInterpreter.getArgument("var", startElementEvent)), this.stringToBool(BooleanInterpreter.getArgument("value", startElementEvent)));
        }
    }

    public String toString() {
        Iterator iterator = this.values.entrySet().iterator();
        String string = "";
        while (iterator.hasNext()) {
            string = string + iterator.next().toString() + " ";
        }
        return string;
    }
}

