/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.IOException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.XMLDeclaration;
import weblogic.xml.babel.scanner.ScannerException;

public class ProcessingInstruction
extends Element {
    String value;
    protected boolean XMLDecl = false;
    protected XMLDeclaration xmlDeclaration = null;

    protected void init() {
        super.init();
        this.value = null;
        this.xmlDeclaration = null;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        this.setPosition(baseParser);
        baseParser.accept(8);
        switch (baseParser.currentToken.tokenType) {
            case 18: {
                this.prefix = baseParser.currentToken.text;
                baseParser.accept();
                this.name = baseParser.currentToken.text;
                baseParser.accept(0);
                break;
            }
            case 0: {
                this.name = baseParser.currentToken.text;
                baseParser.accept();
                break;
            }
            default: {
                throw new ParseException("Expected a NAME", baseParser.getLine(), baseParser.currentToken);
            }
        }
        if (baseParser.compare(17)) {
            this.value = baseParser.currentToken.text;
            baseParser.accept();
            while (baseParser.compare(17) || baseParser.compare(19)) {
                this.value = baseParser.compare(17) ? this.value + baseParser.currentToken.text : this.value + baseParser.currentToken.getArrayAsString();
                baseParser.accept();
            }
        } else {
            this.value = null;
        }
        baseParser.accept(9);
        this.type = 4;
        if (this.name.equals("xml")) {
            this.XMLDecl = true;
            this.xmlDeclaration = new XMLDeclaration(this.value);
            this.xmlDeclaration.parse();
        }
    }

    public boolean isXMLDecl() {
        return this.XMLDecl;
    }

    public String getVersion() {
        if (this.xmlDeclaration == null) {
            return null;
        }
        return this.xmlDeclaration.getVersion();
    }

    public String getEncoding() {
        if (this.xmlDeclaration == null) {
            return null;
        }
        return this.xmlDeclaration.getEncoding();
    }

    public String getStandalone() {
        if (this.xmlDeclaration == null) {
            return null;
        }
        return this.xmlDeclaration.getStandalone();
    }

    public String toString() {
        if (this.value != null) {
            return "<?" + this.getName() + " " + this.value + "?>";
        }
        if (this.name != null) {
            return "<?" + this.getName() + "?>";
        }
        return "<??>";
    }

    public String getTarget() {
        return this.getName();
    }

    public String getData() {
        return this.value;
    }
}

