/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.tcp.TcpIpConnection;
import java.io.EOFException;

public class TcpIpConnectionChannelErrorHandler
implements ChannelErrorHandler {
    private final ILogger logger;

    public TcpIpConnectionChannelErrorHandler(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public void onError(Channel channel, Throwable cause) {
        if (cause instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)cause);
        }
        if (channel == null) {
            this.logger.severe(cause);
        } else {
            TcpIpConnection connection = (TcpIpConnection)channel.attributeMap().get(TcpIpConnection.class);
            if (cause instanceof EOFException) {
                connection.close("Connection closed by the other side", cause);
            } else {
                connection.close("Exception in " + connection + ", thread=" + Thread.currentThread().getName(), cause);
            }
        }
    }
}

