/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.ChannelInboundHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.InitResult;
import com.hazelcast.internal.networking.nio.AbstractHandler;
import com.hazelcast.internal.networking.nio.ChannelInboundHandlerWithCounters;
import com.hazelcast.internal.networking.nio.NioChannel;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.networking.nio.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class NioChannelReader
extends AbstractHandler {
    protected ByteBuffer inputBuffer;
    @Probe(name="bytesRead")
    private final SwCounter bytesRead = SwCounter.newSwCounter();
    @Probe(name="normalFramesRead")
    private final SwCounter normalFramesRead = SwCounter.newSwCounter();
    @Probe(name="priorityFramesRead")
    private final SwCounter priorityFramesRead = SwCounter.newSwCounter();
    private final ChannelInitializer initializer;
    private ChannelInboundHandler inboundHandler;
    private volatile long lastReadTime;
    private volatile long bytesReadLastPublish;
    private volatile long normalFramesReadLastPublish;
    private volatile long priorityFramesReadLastPublish;
    private volatile long handleCountLastPublish;

    public NioChannelReader(NioChannel channel, NioThread ioThread, ILogger logger, IOBalancer balancer, ChannelInitializer initializer) {
        super(channel, ioThread, 1, logger, balancer);
        this.initializer = initializer;
    }

    @Override
    public long getLoad() {
        switch (LOAD_TYPE) {
            case 0: {
                return this.handleCount.get();
            }
            case 1: {
                return this.bytesRead.get();
            }
            case 2: {
                return this.normalFramesRead.get() + this.priorityFramesRead.get();
            }
        }
        throw new RuntimeException();
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastReadTime, 0L);
    }

    public SwCounter getNormalFramesReadCounter() {
        return this.normalFramesRead;
    }

    public SwCounter getPriorityFramesReadCounter() {
        return this.priorityFramesRead;
    }

    public long lastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Override
    public void requestMigration(NioThread newOwner) {
        this.ioThread.addTaskAndWakeup(new StartMigrationTask(newOwner));
    }

    @Override
    public void handle() throws Exception {
        this.handleCount.inc();
        this.lastReadTime = System.currentTimeMillis();
        if (this.inboundHandler == null && !this.init()) {
            return;
        }
        int readBytes = this.channel.read(this.inputBuffer);
        if (readBytes <= 0) {
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
            return;
        }
        this.bytesRead.inc(readBytes);
        this.inputBuffer.flip();
        this.inboundHandler.onRead(this.inputBuffer);
        IOUtil.compactOrClear(this.inputBuffer);
    }

    private boolean init() throws IOException {
        InitResult<ChannelInboundHandler> init = this.initializer.initInbound(this.channel);
        if (init == null) {
            return false;
        }
        this.inboundHandler = init.getHandler();
        this.inputBuffer = init.getByteBuffer();
        if (this.inboundHandler instanceof ChannelInboundHandlerWithCounters) {
            ChannelInboundHandlerWithCounters withCounters = (ChannelInboundHandlerWithCounters)this.inboundHandler;
            withCounters.setNormalPacketsRead(this.normalFramesRead);
            withCounters.setPriorityPacketsRead(this.priorityFramesRead);
        }
        return true;
    }

    @Override
    public void publish() {
        if (Thread.currentThread() != this.ioThread) {
            return;
        }
        this.ioThread.bytesTransceived += this.bytesRead.get() - this.bytesReadLastPublish;
        this.ioThread.framesTransceived += this.normalFramesRead.get() - this.normalFramesReadLastPublish;
        this.ioThread.priorityFramesTransceived += this.priorityFramesRead.get() - this.priorityFramesReadLastPublish;
        this.ioThread.handleCount += this.handleCount.get() - this.handleCountLastPublish;
        this.bytesReadLastPublish = this.bytesRead.get();
        this.normalFramesReadLastPublish = this.normalFramesRead.get();
        this.priorityFramesReadLastPublish = this.priorityFramesRead.get();
        this.handleCountLastPublish = this.handleCount.get();
    }

    @Override
    public void close() {
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                if (NioChannelReader.this.ioThread != Thread.currentThread()) {
                    NioChannelReader.this.ioThread.addTaskAndWakeup(this);
                    return;
                }
                try {
                    NioChannelReader.this.channel.closeInbound();
                }
                catch (IOException e) {
                    NioChannelReader.this.logger.finest("Error while closing inbound", e);
                }
            }
        });
    }

    public String toString() {
        return this.channel + ".channelReader";
    }

    private class StartMigrationTask
    implements Runnable {
        private final NioThread newOwner;

        StartMigrationTask(NioThread newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public void run() {
            if (NioChannelReader.this.ioThread == this.newOwner) {
                return;
            }
            NioChannelReader.this.publish();
            try {
                NioChannelReader.this.startMigration(this.newOwner);
            }
            catch (Throwable t) {
                NioChannelReader.this.onFailure(t);
            }
        }
    }
}

