/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network.chatroom;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openymsg.network.Util;
import org.openymsg.network.chatroom.YahooChatCategory;
import org.openymsg.network.chatroom.YahooChatLobby;

public class ChatroomManager {
    public static final int REFRESH_TIMOUT_IN_SECONDS = 900;
    public static final String PREFIX = "http://";
    public static final String TOP_URL = "insider.msg.yahoo.com/ycontent/?chatcat=0";
    private static final Map<String, YahooChatCategory> roots = new HashMap<String, YahooChatCategory>();
    private static final Map<String, Long> timestamps = new HashMap<String, Long>();
    private final String cLine;
    private final String localePrefix;

    public ChatroomManager(String[] stringArray, String string) {
        this.cLine = stringArray != null ? stringArray[0] + "; " + stringArray[1] : null;
        this.localePrefix = string == null ? "" : (string.endsWith(".") ? string : string + ".");
    }

    private void recursiveLoad(Element element, YahooChatCategory yahooChatCategory, String string) {
        List list = element.getChildren("category");
        for (Element element2 : list) {
            long l = Long.parseLong(element2.getAttributeValue("id"));
            String string2 = element2.getAttributeValue("name");
            YahooChatCategory yahooChatCategory2 = new YahooChatCategory(l, string2, string, this.localePrefix);
            this.recursiveLoad(element2, yahooChatCategory2, string);
            yahooChatCategory.addSubcategory(yahooChatCategory2);
        }
    }

    public synchronized YahooChatCategory loadCategories() throws MalformedURLException, JDOMException, IOException {
        long l;
        long l2 = System.currentTimeMillis();
        if (timestamps.containsKey(this.localePrefix) && (l = timestamps.get(this.localePrefix).longValue()) + 900000L > l2) {
            return roots.get(this.localePrefix);
        }
        String string = PREFIX + this.localePrefix + TOP_URL;
        URLConnection uRLConnection = new URL(string).openConnection();
        Util.initURLConnection(uRLConnection);
        if (this.cLine != null) {
            uRLConnection.setRequestProperty("Cookie", this.cLine);
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(new URL(string));
        Element element = document.getRootElement();
        YahooChatCategory yahooChatCategory = new YahooChatCategory(Long.parseLong(element.getAttributeValue("time")), "<root>", this.cLine, this.localePrefix);
        this.recursiveLoad(element.getChild("chatCategories"), yahooChatCategory, this.cLine);
        timestamps.put(this.localePrefix, l2);
        roots.put(this.localePrefix, yahooChatCategory);
        return yahooChatCategory;
    }

    public YahooChatLobby getLobby(String string) {
        YahooChatCategory yahooChatCategory = roots.get(this.localePrefix);
        if (yahooChatCategory == null) {
            throw new IllegalStateException("Root category for this locale (" + this.localePrefix + ") has not been loaded yet.");
        }
        return yahooChatCategory.getLobby(string);
    }
}

