/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.invitation;

import net.sf.jml.message.invitation.InviteCache;
import net.sf.jml.message.invitation.MsnAcceptMessage;
import net.sf.jml.message.invitation.MsnCancelMessage;
import net.sf.jml.message.invitation.MsnInvitationMessage;
import net.sf.jml.message.invitation.MsnInviteMessage;
import net.sf.jml.message.invitation.MsnUnknownAcceptMessage;
import net.sf.jml.message.invitation.MsnUnknownInviteMessage;
import net.sf.jml.message.invitation.MsnftpAcceptMessage;
import net.sf.jml.message.invitation.MsnftpInviteMessage;
import net.sf.jml.util.StringHolder;

public class MsnInvitationMessageFactory {
    public static MsnInvitationMessage parseMessage(String string) {
        StringHolder stringHolder = new StringHolder();
        stringHolder.parseString(string);
        String string2 = stringHolder.getProperty("Invitation-Command");
        if (string2.equalsIgnoreCase("INVITE")) {
            return MsnInvitationMessageFactory.parseInviteMessage(stringHolder);
        }
        if (string2.equalsIgnoreCase("ACCEPT")) {
            return MsnInvitationMessageFactory.parseAcceptMessage(stringHolder);
        }
        if (string2.equalsIgnoreCase("CANCEL")) {
            return MsnInvitationMessageFactory.parseCancelMessage(stringHolder);
        }
        return null;
    }

    private static MsnInviteMessage parseInviteMessage(StringHolder stringHolder) {
        String string = stringHolder.getProperty("Application-GUID");
        if (string.equals("{5D3E02AB-6190-11d3-BBBB-00C04F795683}")) {
            return new MsnftpInviteMessage();
        }
        return new MsnUnknownInviteMessage();
    }

    private static MsnAcceptMessage parseAcceptMessage(StringHolder stringHolder) {
        MsnInviteMessage msnInviteMessage;
        int n = stringHolder.getIntProperty("Invitation-Cookie");
        if (n > 0 && (msnInviteMessage = InviteCache.getInvite(n)) != null) {
            if (msnInviteMessage.getApplicationGUID().equals("{5D3E02AB-6190-11d3-BBBB-00C04F795683}")) {
                return new MsnftpAcceptMessage((MsnftpInviteMessage)msnInviteMessage);
            }
            return new MsnUnknownAcceptMessage(msnInviteMessage);
        }
        return null;
    }

    private static MsnCancelMessage parseCancelMessage(StringHolder stringHolder) {
        MsnInviteMessage msnInviteMessage;
        int n = stringHolder.getIntProperty("Invitation-Cookie");
        if (n > 0 && (msnInviteMessage = InviteCache.getInvite(n)) != null) {
            return new MsnCancelMessage(msnInviteMessage);
        }
        return null;
    }
}

