/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SortedHashMap<K, V>
extends AbstractMap<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    int modCount = 0;
    Entry<K, V>[] table;
    private transient Entry<K, V> header = null;
    int size;
    int threshold;
    final float loadFactor;
    final OrderingType orderingType;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;

    public SortedHashMap() {
        this(16, 0.75f, OrderingType.NONE);
    }

    public SortedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, OrderingType.NONE);
    }

    public SortedHashMap(int initialCapacity, OrderingType orderingType) {
        this(initialCapacity, 0.75f, orderingType);
    }

    public SortedHashMap(int initialCapacity, float loadFactor, OrderingType orderingType) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.orderingType = orderingType;
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.header = new Entry<Object, Object>(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    public V put(K key, V value) {
        int hash = SortedHashMap.hash(key.hashCode());
        int i = SortedHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return null;
    }

    public static void touch(SortedHashMap linkedMap, Object key, OrderingType orderingType) {
        Entry e = linkedMap.getEntry(key);
        if (e != null) {
            e.touch(linkedMap, orderingType);
        }
    }

    public static void moveToTop(SortedHashMap linkedMap, Object key) {
        Entry e = linkedMap.getEntry(key);
        if (e != null) {
            e.moveToTop(linkedMap);
        }
    }

    public static OrderingType getOrderingTypeByName(String orderingType) {
        return OrderingType.valueOf(orderingType.toUpperCase());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return e.value;
    }

    Entry<K, V> getEntry(Object k) {
        int hash = SortedHashMap.hash(k.hashCode());
        int i = SortedHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e = this.table[i];
        while (!(e == null || e.hash == hash && SortedHashMap.eq(k, e.key))) {
            e = e.next;
        }
        return e;
    }

    static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K, V>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e = this.removeEntryForKey(key);
        return e == null ? null : (V)e.value;
    }

    Entry<K, V> removeEntryForKey(Object k) {
        Entry<K, V> prev;
        int hash = SortedHashMap.hash(k.hashCode());
        int i = SortedHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && (k == e.key || k.equals(e.key))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry<K, V> removeMapping(Object o) {
        Entry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)o;
        Object k = entry.getKey();
        int hash = SortedHashMap.hash(k.hashCode());
        int i = SortedHashMap.indexFor(hash, this.table.length);
        Entry<K, V> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    void addEntry(int hash, K key, V value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> old = this.table[bucketIndex];
        Entry<K, V> e = new Entry<K, V>(hash, key, value, old);
        this.table[bucketIndex] = e;
        ((Entry)e).addBefore((Entry)this.header);
        ++this.size;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = SortedHashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return SortedHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = SortedHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return SortedHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return SortedHashMap.this.size;
        }

        @Override
        public void clear() {
            SortedHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return SortedHashMap.this.newValueIterator();
        }

        @Override
        public int size() {
            return SortedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SortedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            SortedHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return SortedHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return SortedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return SortedHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return SortedHashMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            SortedHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((SortedHashMap)SortedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = SortedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != SortedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SortedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SortedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = SortedHashMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            if (SortedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == SortedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry e = this.lastReturned;
            this.nextEntry = e.after;
            return e;
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        Entry<K, V> next;
        Entry<K, V> after;
        Entry<K, V> before;
        long accessCount = 1L;
        long lastAccess = 0L;
        int hash = -1;

        Entry(int hash, K key, V value, Entry<K, V> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
            this.lastAccess = Clock.currentTimeMillis();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return "Entry key=" + this.getKey() + ", value=" + this.getValue();
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        private void addAfter(Entry<K, V> existingEntry) {
            this.addBefore(existingEntry.after);
        }

        void recordAccess(SortedHashMap<K, V> lm) {
            this.touch(lm, lm.orderingType);
        }

        void touch(SortedHashMap<K, V> lm, OrderingType orderingType) {
            if (orderingType != OrderingType.NONE) {
                this.lastAccess = Clock.currentTimeMillis();
                ++this.accessCount;
                ++lm.modCount;
                if (orderingType == OrderingType.LFU) {
                    this.moveLFU(lm);
                } else if (orderingType == OrderingType.LRU) {
                    this.moveLRU(lm);
                } else if (orderingType == OrderingType.HASH) {
                    this.moveHash(lm);
                } else {
                    throw new RuntimeException("Unknown orderingType:" + (Object)((Object)lm.orderingType));
                }
            }
        }

        void moveLRU(SortedHashMap lm) {
            this.remove();
            this.addBefore(lm.header);
        }

        void moveLFU(SortedHashMap lm) {
            Entry<K, V> nextOne = this.after;
            boolean shouldMove = false;
            while (nextOne != null && this.accessCount >= nextOne.accessCount && nextOne != lm.header) {
                shouldMove = true;
                nextOne = nextOne.after;
            }
            if (shouldMove) {
                this.remove();
                this.addBefore(nextOne);
            }
        }

        void moveHash(SortedHashMap lm) {
            Entry<K, V> nextOne = this.after;
            boolean shouldMove = false;
            while (nextOne != null && nextOne != lm.header && this.value.hashCode() >= nextOne.value.hashCode()) {
                shouldMove = true;
                nextOne = nextOne.after;
            }
            if (shouldMove) {
                this.remove();
                this.addBefore(nextOne);
            }
        }

        void moveToTop(SortedHashMap lm) {
            this.remove();
            this.addAfter(lm.header);
        }

        void recordRemoval(SortedHashMap<K, V> lm) {
            this.remove();
        }
    }

    public static enum OrderingType {
        NONE,
        LRU,
        LFU,
        HASH;

    }
}

