/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.client;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.PartitionDataSerializerHook;
import java.io.IOException;

public final class PartitionsResponse
implements IdentifiedDataSerializable {
    private Address[] members;
    private int[] ownerIndexes;

    public PartitionsResponse() {
    }

    public PartitionsResponse(Address[] members, int[] ownerIndexes) {
        this.members = members;
        this.ownerIndexes = ownerIndexes;
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.members.length);
        for (Address member : this.members) {
            member.writeData(out);
        }
        out.writeInt(this.ownerIndexes.length);
        for (int index : this.ownerIndexes) {
            out.writeInt(index);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int i;
        int len = in.readInt();
        this.members = new Address[len];
        for (i = 0; i < len; ++i) {
            Address a = new Address();
            a.readData(in);
            this.members[i] = a;
        }
        len = in.readInt();
        this.ownerIndexes = new int[len];
        for (i = 0; i < len; ++i) {
            this.ownerIndexes[i] = in.readInt();
        }
    }

    public Address[] getMembers() {
        return this.members;
    }

    public int[] getOwnerIndexes() {
        return this.ownerIndexes;
    }
}

