/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.StringBlock;

public final class OscarTools {
    private static final Logger logger = Logger.getLogger("net.kano.joscar");
    private static final Pattern typePattern = Pattern.compile("[;=\\s]*+(\\S+?)\\s*(?:=\\s*(?:\"(.*?)\"|(\\S*?))\\s*)?(?:[=\\s]*;[=\\s]*|\\z)");
    private static final Pattern charsetPattern = Pattern.compile("[A-Za-z0-9][A-Za-z0-9-.:_]*");
    private static final Pattern ucsPattern = Pattern.compile("ucs-2([bl]e)?");
    private static final Pattern htmlRE = Pattern.compile("<[^>]*>");
    private static final Pattern httpHeaderRE = Pattern.compile("((.*?)(?:: ?(.*))?)(\r\n|\r|\n)");
    private static final Pattern roomNameRE = Pattern.compile("!aol://\\d+:\\d+-\\d+-(.*)");

    private OscarTools() {
    }

    public static StringBlock readScreenname(ByteBlock byteBlock) {
        if (byteBlock.getLength() < 1) {
            return null;
        }
        short s = BinaryTools.getUByte(byteBlock, 0);
        if (s > byteBlock.getLength() - 1) {
            return null;
        }
        String string = BinaryTools.getAsciiString(byteBlock.subBlock(1, s));
        return new StringBlock(string, s + 1);
    }

    public static void writeScreenname(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = BinaryTools.getAsciiBytes(string);
        BinaryTools.writeUByte(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    public static Map parseContentTypeString(String string) {
        Matcher matcher = typePattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string3 == null) {
                string3 = matcher.group(3);
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private static boolean isValidCharset(String string) {
        return charsetPattern.matcher(string).matches();
    }

    private static String fixCharset(String string) {
        Object object;
        if (string == null) {
            return "US-ASCII";
        }
        String string2 = string.toLowerCase();
        if (string2.equals("unicode-2-0")) {
            return "UTF-16BE";
        }
        if (string2.startsWith("unicode-2-0-") && OscarTools.isValidCharset((String)(object = string.substring(12))) && Charset.isSupported((String)object)) {
            return object;
        }
        object = ucsPattern.matcher(string);
        if (((Matcher)object).matches()) {
            String string3 = ((Matcher)object).group(1);
            String string4 = "utf-16";
            if (string3 != null) {
                string4 = string4 + string3;
            }
            return string4;
        }
        return "US-ASCII";
    }

    public static String getInfoString(ByteBlock byteBlock, String string) {
        String string2;
        if (string != null) {
            Map map = OscarTools.parseContentTypeString(string);
            string2 = (String)map.get("charset");
            string2 = OscarTools.getValidCharset(string2);
        } else {
            string2 = "US-ASCII";
        }
        try {
            return ByteBlock.createString(byteBlock, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String getValidCharset(String string) {
        String string2 = string;
        if (string2 == null || !OscarTools.isValidCharset(string2)) {
            string2 = OscarTools.fixCharset(string2);
        } else {
            try {
                if (!Charset.isSupported(string2)) {
                    string2 = OscarTools.fixCharset(string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                logger.warning("Illegal charset name: " + string2 + ": " + illegalCharsetNameException.getMessage());
                string2 = OscarTools.fixCharset(string2);
            }
        }
        return string2;
    }

    public static String getString(ByteBlock byteBlock, String string) {
        String string2 = OscarTools.getValidCharset(string);
        try {
            return ByteBlock.createString(byteBlock, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') continue;
            stringBuffer.append(Character.toLowerCase(c));
        }
        return stringBuffer.toString();
    }

    public static String stripHtml(String string) {
        return htmlRE.matcher(string).replaceAll("");
    }

    public static HttpHeaderInfo parseHttpHeader(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "data");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DynAsciiCharSequence dynAsciiCharSequence = new DynAsciiCharSequence(byteBlock);
        Matcher matcher = httpHeaderRE.matcher(dynAsciiCharSequence);
        int n = -1;
        while (matcher.find()) {
            if (matcher.group(1).trim().length() == 0) {
                n = matcher.end();
                break;
            }
            String string = matcher.group(2);
            String string2 = matcher.group(3);
            hashMap.put(string.toLowerCase(), string2);
            hashMap.put(string, string2);
        }
        return new HttpHeaderInfo(hashMap, n == -1 ? null : byteBlock.subBlock(n));
    }

    public static final String getRoomNameFromCookie(String string) {
        Matcher matcher = roomNameRE.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = null;
        try {
            string3 = URLDecoder.decode(string2, "us-ascii");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string3;
    }

    private static class DynAsciiCharSequence
    implements CharSequence {
        private final ByteBlock data;

        public DynAsciiCharSequence(ByteBlock byteBlock) {
            DefensiveTools.checkNull(byteBlock, "data");
            this.data = byteBlock;
        }

        public char charAt(int n) {
            return (char)this.data.get(n);
        }

        public int length() {
            return this.data.getLength();
        }

        public CharSequence subSequence(int n, int n2) {
            return new DynAsciiCharSequence(this.data.subBlock(n, n2 - n));
        }

        public String toString() {
            return BinaryTools.getAsciiString(this.data);
        }
    }

    public static final class HttpHeaderInfo {
        private final Map headers;
        private final ByteBlock data;

        private HttpHeaderInfo(Map map, ByteBlock byteBlock) {
            DefensiveTools.checkNull(map, "headers");
            DefensiveTools.checkNull(byteBlock, "data");
            this.headers = Collections.unmodifiableMap(map);
            this.data = byteBlock;
        }

        public String get(String string) {
            return (String)this.headers.get(string);
        }

        public Map getHeaders() {
            return this.headers;
        }

        public ByteBlock getData() {
            return this.data;
        }
    }
}

