/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaBasicInfoCmd
extends AbstractInfoCmd {
    private static final int NDX_NICKNAME = 0;
    private static final int NDX_FNAME = 1;
    private static final int NDX_LNAME = 2;
    private static final int NDX_EMAIL = 3;
    private static final int NDX_HOME_CITY = 4;
    private static final int NDX_HOME_STATE = 5;
    private static final int NDX_HOME_PHONE = 6;
    private static final int NDX_HOME_FAX = 7;
    private static final int NDX_HOME_ADDRESS = 8;
    private static final int NDX_CELL_PHONE = 9;
    private static final int NDX_HOME_ZIP = 10;
    private String[] s;
    private int countryCode;
    private int gmtOffset;
    private boolean authorization;
    private boolean webAware;
    private boolean publishPrimaryEmail;

    public MetaBasicInfoCmd(SnacPacket packet) {
        super(packet);
    }

    protected void readInfo(InputStream is) throws IOException {
        this.s = new String[11];
        for (int i = 0; i < this.s.length; ++i) {
            this.s[i] = LEBinaryTools.readUShortLengthString(is, "US-ASCII");
            if (this.s[i] == null) break;
        }
        this.countryCode = LEBinaryTools.readUShort(is);
        this.gmtOffset = is.read();
        this.authorization = is.read() > 0;
        this.webAware = is.read() > 0;
        this.publishPrimaryEmail = is.read() > 0;
    }

    protected void writeInfo(OutputStream out) throws IOException {
        for (String value : this.s) {
            LEBinaryTools.writeUShortLengthString(out, value);
        }
        LEBinaryTools.writeUShort(out, this.countryCode);
        LEBinaryTools.writeUByte(out, this.gmtOffset);
        LEBinaryTools.writeUByte(out, this.authorization ? 1 : 0);
        LEBinaryTools.writeUByte(out, this.webAware ? 1 : 0);
        LEBinaryTools.writeUByte(out, this.publishPrimaryEmail ? 1 : 0);
    }

    public MetaBasicInfoCmd(int uin, int id, String nickname, String fname, String lname, String email, String homeCity, String homeState, String homePhone, String homeFax, String homeAddress, String cellPhone, String homeZip) {
        super(uin, AbstractIcqCmd.CMD_META_BASIC_INFO_CMD, id);
        this.s = new String[11];
        this.s[0] = nickname;
        this.s[1] = fname;
        this.s[2] = lname;
        this.s[3] = email;
        this.s[4] = homeCity;
        this.s[5] = homeState;
        this.s[6] = homePhone;
        this.s[7] = homeFax;
        this.s[8] = homeAddress;
        this.s[9] = cellPhone;
        this.s[10] = homeZip;
    }

    public String getNickname() {
        return this.s[0];
    }

    public String getFirstName() {
        return this.s[1];
    }

    public String getLastName() {
        return this.s[2];
    }

    public String getEmail() {
        return this.s[3];
    }

    public String getHomeCity() {
        return this.s[4];
    }

    public String getHomeState() {
        return this.s[5];
    }

    public String getHomePhone() {
        return this.s[6];
    }

    public String getHomeFax() {
        return this.s[7];
    }

    public String getHomeAddress() {
        return this.s[8];
    }

    public String getCellPhone() {
        return this.s[9];
    }

    public String getHomeZip() {
        return this.s[10];
    }

    public void setCountryCode(int countryCode) {
        this.countryCode = countryCode;
    }

    public void setGmtOffset(int gmtOffset) {
        this.gmtOffset = gmtOffset;
    }

    public void setAuthorization(boolean authorization) {
        this.authorization = authorization;
    }

    public void setWebAware(boolean webAware) {
        this.webAware = webAware;
    }

    public void setPublishPrimaryEmail(boolean publishPrimaryEmail) {
        this.publishPrimaryEmail = publishPrimaryEmail;
    }

    public int getCountryCode() {
        return this.countryCode;
    }

    public int getGmtOffset() {
        return this.gmtOffset;
    }

    public boolean isAuthorization() {
        return this.authorization;
    }

    public boolean isWebAware() {
        return this.webAware;
    }

    public boolean isPublishPrimaryEmail() {
        return this.publishPrimaryEmail;
    }

    public String toString() {
        return "MetaBasicInfoCmd: nick=" + this.getNickname() + " firstname=" + this.getFirstName() + " lastname=" + this.getLastName() + " email=" + this.getEmail() + " homeCity=" + this.getHomeCity() + " homeState=" + this.getHomeState() + " homePhone=" + this.getHomePhone() + " homeFax=" + this.getHomeFax() + " homeAddress=" + this.getHomeAddress() + " cellPhone=" + this.getCellPhone() + " homeZip=" + this.getHomeZip() + " countryCode=" + this.getCountryCode() + " gmtOffset=" + this.getGmtOffset() + " authorization=" + this.isAuthorization() + " webAware=" + this.isWebAware() + " publishPrimaryEmail=" + this.isPublishPrimaryEmail() + " in: " + super.toString();
    }
}

