/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public abstract class AcctResponse
extends AcctCommand {
    public static final int ERRORCODE_CANNOT_DISPLAY_INFO = 18;
    public static final int ERRORCODE_NO_EMAIL = 21;
    public static final int TYPE_DEFAULT = 3;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_ERROR = 3;
    private static final int TYPE_SN = 1;
    private static final int TYPE_EMAIL = 17;
    private static final int TYPE_ERROR_CODE = 8;
    private static final int TYPE_ERROR_URL = 4;
    private static final int TYPE_SOMETHING = 19;
    private final int type;
    private final int result;
    private final String sn;
    private final String email;
    private final int errorCode;
    private final String errorUrl;

    protected AcctResponse(int command, SnacPacket packet) {
        super(command);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock block = packet.getData();
        this.type = BinaryTools.getUShort((ByteBlock)block, (int)0);
        this.result = BinaryTools.getUShort((ByteBlock)block, (int)2);
        ByteBlock tlvBlock = block.subBlock(4);
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.sn = chain.getString(1);
        this.email = chain.getString(17);
        this.errorCode = chain.getUShort(8);
        this.errorUrl = chain.getString(4);
    }

    protected AcctResponse(int command, int result) {
        this(command, 3, result, null, null, -1, null);
    }

    protected AcctResponse(int command, int errorCode, String errorURL) {
        this(command, 3, 3, null, null, errorCode, errorURL);
    }

    protected AcctResponse(int command, int type, int result, String sn, String email, int errorCode, String errorUrl) {
        super(command);
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        DefensiveTools.checkRange((int)result, (String)"result", (int)0);
        DefensiveTools.checkRange((int)errorCode, (String)"errorCode", (int)-1);
        this.type = type;
        this.result = result;
        this.sn = sn;
        this.email = email;
        this.errorCode = errorCode;
        this.errorUrl = errorUrl;
    }

    public final int getType() {
        return this.type;
    }

    public final int getResult() {
        return this.result;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getEmail() {
        return this.email;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.type);
        BinaryTools.writeUShort((OutputStream)out, (int)this.result);
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(out);
        }
        if (this.email != null) {
            Tlv.getStringInstance(17, this.email).write(out);
        }
        if (this.errorCode != -1) {
            Tlv.getUShortInstance(8, this.errorCode).write(out);
        }
        if (this.errorUrl != null) {
            Tlv.getStringInstance(4, this.errorUrl).write(out);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": type=" + this.type + ", result=" + this.result + ", sn=" + this.sn + ", email=" + this.email + ", error=" + this.errorCode + ", errurl=" + this.errorUrl;
    }
}

