/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.ArcState;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.DataImporter;
import org.jrobin.core.FetchData;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class Archive
implements RrdUpdater,
ConsolFuns {
    private RrdDb parentDb;
    private RrdString consolFun;
    private RrdDouble xff;
    private RrdInt steps;
    private RrdInt rows;
    private Robin[] robins;
    private ArcState[] states;

    Archive(RrdDb rrdDb, ArcDef arcDef) throws IOException {
        boolean bl = arcDef != null;
        this.parentDb = rrdDb;
        this.consolFun = new RrdString(this, true);
        this.xff = new RrdDouble(this);
        this.steps = new RrdInt(this, true);
        this.rows = new RrdInt(this, true);
        if (bl) {
            this.consolFun.set(arcDef.getConsolFun());
            this.xff.set(arcDef.getXff());
            this.steps.set(arcDef.getSteps());
            this.rows.set(arcDef.getRows());
        }
        int n = rrdDb.getHeader().getDsCount();
        this.states = new ArcState[n];
        this.robins = new Robin[n];
        for (int i = 0; i < n; ++i) {
            this.states[i] = new ArcState(this, bl);
            int n2 = this.rows.get();
            this.robins[i] = new Robin(this, n2, bl);
        }
    }

    Archive(RrdDb rrdDb, DataImporter dataImporter, int n) throws IOException, RrdException {
        this(rrdDb, new ArcDef(dataImporter.getConsolFun(n), dataImporter.getXff(n), dataImporter.getSteps(n), dataImporter.getRows(n)));
        int n2 = rrdDb.getHeader().getDsCount();
        for (int i = 0; i < n2; ++i) {
            this.states[i].setAccumValue(dataImporter.getStateAccumValue(n, i));
            this.states[i].setNanSteps(dataImporter.getStateNanSteps(n, i));
            double[] dArray = dataImporter.getValues(n, i);
            this.robins[i].update(dArray);
        }
    }

    public long getArcStep() throws IOException {
        long l = this.parentDb.getHeader().getStep();
        return l * (long)this.steps.get();
    }

    String dump() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("== ARCHIVE ==\n");
        stringBuffer.append("RRA:").append(this.consolFun.get()).append(":").append(this.xff.get()).append(":").append(this.steps.get()).append(":").append(this.rows.get()).append("\n");
        stringBuffer.append("interval [").append(this.getStartTime()).append(", ").append(this.getEndTime()).append("]\n");
        for (int i = 0; i < this.robins.length; ++i) {
            stringBuffer.append(this.states[i].dump());
            stringBuffer.append(this.robins[i].dump());
        }
        return stringBuffer.toString();
    }

    RrdDb getParentDb() {
        return this.parentDb;
    }

    void archive(int n, double d, long l) throws IOException {
        Robin robin = this.robins[n];
        ArcState arcState = this.states[n];
        long l2 = this.parentDb.getHeader().getStep();
        long l3 = this.parentDb.getHeader().getLastUpdateTime();
        long l4 = Util.normalize(l3, l2) + l2;
        long l5 = this.getArcStep();
        while (l > 0L) {
            this.accumulate(arcState, d);
            --l;
            if (l4 % l5 == 0L) {
                this.finalizeStep(arcState, robin);
                break;
            }
            l4 += l2;
        }
        int n2 = (int)Math.min(l / (long)this.steps.get(), (long)this.rows.get());
        robin.bulkStore(d, n2);
        long l6 = l % (long)this.steps.get();
        for (long i = 0L; i < l6; ++i) {
            this.accumulate(arcState, d);
        }
    }

    private void accumulate(ArcState arcState, double d) throws IOException {
        if (Double.isNaN(d)) {
            arcState.setNanSteps(arcState.getNanSteps() + 1L);
        } else if (this.consolFun.get().equals("MIN")) {
            arcState.setAccumValue(Util.min(arcState.getAccumValue(), d));
        } else if (this.consolFun.get().equals("MAX")) {
            arcState.setAccumValue(Util.max(arcState.getAccumValue(), d));
        } else if (this.consolFun.get().equals("LAST")) {
            arcState.setAccumValue(d);
        } else if (this.consolFun.get().equals("AVERAGE")) {
            arcState.setAccumValue(Util.sum(arcState.getAccumValue(), d));
        }
    }

    private void finalizeStep(ArcState arcState, Robin robin) throws IOException {
        long l = this.steps.get();
        double d = this.xff.get();
        long l2 = arcState.getNanSteps();
        double d2 = arcState.getAccumValue();
        if ((double)l2 <= d * (double)l && !Double.isNaN(d2)) {
            if (this.consolFun.get().equals("AVERAGE")) {
                d2 /= (double)(l - l2);
            }
            robin.store(d2);
        } else {
            robin.store(Double.NaN);
        }
        arcState.setAccumValue(Double.NaN);
        arcState.setNanSteps(0L);
    }

    public String getConsolFun() throws IOException {
        return this.consolFun.get();
    }

    public double getXff() throws IOException {
        return this.xff.get();
    }

    public int getSteps() throws IOException {
        return this.steps.get();
    }

    public int getRows() throws IOException {
        return this.rows.get();
    }

    public long getStartTime() throws IOException {
        long l = this.getEndTime();
        long l2 = this.getArcStep();
        long l3 = this.rows.get();
        return l - (l3 - 1L) * l2;
    }

    public long getEndTime() throws IOException {
        long l = this.getArcStep();
        long l2 = this.parentDb.getHeader().getLastUpdateTime();
        return Util.normalize(l2, l);
    }

    public ArcState getArcState(int n) {
        return this.states[n];
    }

    public Robin getRobin(int n) {
        return this.robins[n];
    }

    FetchData fetchData(FetchRequest fetchRequest) throws IOException, RrdException {
        int n;
        int n2;
        long l = this.getArcStep();
        long l2 = Util.normalize(fetchRequest.getFetchStart(), l);
        long l3 = Util.normalize(fetchRequest.getFetchEnd(), l);
        if (l3 < fetchRequest.getFetchEnd()) {
            l3 += l;
        }
        long l4 = this.getStartTime();
        long l5 = this.getEndTime();
        String[] stringArray = fetchRequest.getFilter();
        if (stringArray == null) {
            stringArray = this.parentDb.getDsNames();
        }
        int n3 = stringArray.length;
        int n4 = (int)((l3 - l2) / l + 1L);
        long[] lArray = new long[n4];
        double[][] dArray = new double[n3][n4];
        long l6 = Math.max(l2, l4);
        long l7 = Math.min(l3, l5);
        Object object = null;
        if (l6 <= l7) {
            n2 = (int)((l7 - l6) / l + 1L);
            int n5 = (int)((l6 - l4) / l);
            object = new double[n3][];
            for (int i = 0; i < n3; ++i) {
                n = this.parentDb.getDsIndex(stringArray[i]);
                object[i] = this.robins[n].getValues(n5, n2);
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            long l8;
            lArray[n2] = l8 = l2 + (long)n2 * l;
            for (n = 0; n < n3; ++n) {
                double d = Double.NaN;
                if (l8 >= l6 && l8 <= l7) {
                    int n6 = (int)((l8 - l6) / l);
                    assert (object != null);
                    d = object[n][n6];
                }
                dArray[n][n2] = d;
            }
        }
        FetchData fetchData = new FetchData(this, fetchRequest);
        fetchData.setTimestamps(lArray);
        fetchData.setValues(dArray);
        return fetchData;
    }

    void appendXml(XmlWriter xmlWriter) throws IOException {
        int n;
        xmlWriter.startTag("rra");
        xmlWriter.writeTag("cf", this.consolFun.get());
        xmlWriter.writeComment(this.getArcStep() + " seconds");
        xmlWriter.writeTag("pdp_per_row", this.steps.get());
        xmlWriter.writeTag("xff", this.xff.get());
        xmlWriter.startTag("cdp_prep");
        ArcState[] arcStateArray = this.states;
        int n2 = arcStateArray.length;
        for (n = 0; n < n2; ++n) {
            ArcState arcState = arcStateArray[n];
            arcState.appendXml(xmlWriter);
        }
        xmlWriter.closeTag();
        xmlWriter.startTag("database");
        long l = this.getStartTime();
        for (n = 0; n < this.rows.get(); ++n) {
            long l2 = l + (long)n * this.getArcStep();
            xmlWriter.writeComment(Util.getDate(l2) + " / " + l2);
            xmlWriter.startTag("row");
            for (Robin robin : this.robins) {
                xmlWriter.writeTag("v", robin.getValue(n));
            }
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException, RrdException {
        if (!(rrdUpdater instanceof Archive)) {
            throw new RrdException("Cannot copy Archive object to " + rrdUpdater.getClass().getName());
        }
        Archive archive = (Archive)rrdUpdater;
        if (!archive.consolFun.get().equals(this.consolFun.get())) {
            throw new RrdException("Incompatible consolidation functions");
        }
        if (archive.steps.get() != this.steps.get()) {
            throw new RrdException("Incompatible number of steps");
        }
        int n = this.parentDb.getHeader().getDsCount();
        for (int i = 0; i < n; ++i) {
            int n2 = Util.getMatchingDatasourceIndex(this.parentDb, i, archive.parentDb);
            if (n2 < 0) continue;
            this.states[i].copyStateTo(archive.states[n2]);
            this.robins[i].copyStateTo(archive.robins[n2]);
        }
    }

    public void setXff(double d) throws RrdException, IOException {
        if (d < 0.0 || d >= 1.0) {
            throw new RrdException("Invalid xff supplied (" + d + "), must be >= 0 and < 1");
        }
        this.xff.set(d);
    }

    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

