/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.chatinvite;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class ChatInvitationRvCmd
extends AbstractRequestRvCmd {
    private static final int TYPE_SECURE = 17;
    private static final int TYPE_SECURITYINFO = 10003;
    private final InvitationMessage invMessage;
    private final MiniRoomInfo roomInfo;
    private final ByteBlock securityInfo;

    public ChatInvitationRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.invMessage = InvitationMessage.readInvitationMessage(tlvChain);
        Tlv tlv = tlvChain.getLastTlv(10003);
        this.securityInfo = tlv != null ? tlv.getData() : null;
        ByteBlock byteBlock = this.getServiceData();
        this.roomInfo = byteBlock == null ? null : MiniRoomInfo.readMiniRoomInfo(byteBlock);
    }

    public ChatInvitationRvCmd(MiniRoomInfo miniRoomInfo, InvitationMessage invitationMessage) {
        this(miniRoomInfo, invitationMessage, null);
    }

    public ChatInvitationRvCmd(MiniRoomInfo miniRoomInfo, InvitationMessage invitationMessage, ByteBlock byteBlock) {
        super(CapabilityBlock.BLOCK_CHAT);
        this.roomInfo = miniRoomInfo;
        this.invMessage = invitationMessage;
        this.securityInfo = byteBlock;
    }

    public final InvitationMessage getInvMessage() {
        return this.invMessage;
    }

    public final ByteBlock getSecurityInfo() {
        return this.securityInfo;
    }

    public final MiniRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    protected void writeRvTlvs(OutputStream outputStream) throws IOException {
        if (this.invMessage != null) {
            this.invMessage.write(outputStream);
        }
        if (this.securityInfo != null) {
            new Tlv(17).write(outputStream);
            new Tlv(10003, this.securityInfo).write(outputStream);
        }
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
        if (this.roomInfo != null) {
            this.roomInfo.write(outputStream);
        }
    }

    public String toString() {
        return "ChatInvitationRvCmd: " + (this.securityInfo != null ? "(secure) " : "") + "roomInfo=<" + this.roomInfo + ">: " + this.invMessage;
    }
}

