/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SizeSelector
extends BaseExtendSelector {
    public static final String SIZE_KEY = "value";
    public static final String UNITS_KEY = "units";
    public static final String WHEN_KEY = "when";
    private long size;
    private long multiplier;
    private long sizelimit;
    private int cmp;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{sizeselector value: ");
        stringBuffer.append(this.sizelimit);
        stringBuffer.append("compare: ");
        if (this.cmp == 0) {
            stringBuffer.append("less");
        } else if (this.cmp == 1) {
            stringBuffer.append("more");
        } else {
            stringBuffer.append("equal");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setValue(long l) {
        this.size = l;
        if (this.multiplier != 0L && l > (long)-1) {
            this.sizelimit = l * this.multiplier;
        }
    }

    public void setUnits(ByteUnits byteUnits) {
        int n = byteUnits.getIndex();
        this.multiplier = 0L;
        if (n > -1 && n < 4) {
            this.multiplier = 1000L;
        } else if (n > 3 && n < 9) {
            this.multiplier = 1024L;
        } else if (n > 8 && n < 13) {
            this.multiplier = 1000000L;
        } else if (n > 12 && n < 18) {
            this.multiplier = 0x100000L;
        } else if (n > 17 && n < 22) {
            this.multiplier = 1000000000L;
        } else if (n > 21 && n < 27) {
            this.multiplier = 0x40000000L;
        } else if (n > 26 && n < 31) {
            this.multiplier = 1000000000000L;
        } else if (n > 30 && n < 36) {
            this.multiplier = 0x10000000000L;
        }
        if (this.multiplier > 0L && this.size > (long)-1) {
            this.sizelimit = this.size * this.multiplier;
        }
    }

    public void setWhen(SizeComparisons sizeComparisons) {
        this.cmp = sizeComparisons.getIndex();
    }

    public void setParameters(Parameter[] parameterArray) {
        super.setParameters(parameterArray);
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                EnumeratedAttribute enumeratedAttribute;
                String string = parameterArray[n].getName();
                if (SIZE_KEY.equalsIgnoreCase(string)) {
                    try {
                        this.setValue(new Long(parameterArray[n].getValue()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setError("Invalid size setting " + parameterArray[n].getValue());
                    }
                } else if (UNITS_KEY.equalsIgnoreCase(string)) {
                    enumeratedAttribute = new ByteUnits();
                    enumeratedAttribute.setValue(parameterArray[n].getValue());
                    this.setUnits((ByteUnits)enumeratedAttribute);
                } else if (WHEN_KEY.equalsIgnoreCase(string)) {
                    enumeratedAttribute = new SizeComparisons();
                    enumeratedAttribute.setValue(parameterArray[n].getValue());
                    this.setWhen((SizeComparisons)enumeratedAttribute);
                } else {
                    this.setError("Invalid parameter " + string);
                }
                ++n;
            }
        }
    }

    public void verifySettings() {
        if (this.size < 0L) {
            this.setError("The value attribute is required, and must be positive");
        } else if (this.multiplier < 1L) {
            this.setError("Invalid Units supplied, must be K,Ki,M,Mi,G,Gi,T,or Ti");
        } else if (this.sizelimit < 0L) {
            this.setError("Internal error: Code is not setting sizelimit correctly");
        }
    }

    public boolean isSelected(File file, String string, File file2) {
        this.validate();
        if (file2.isDirectory()) {
            return true;
        }
        if (this.cmp == 0) {
            boolean bl = false;
            if (file2.length() < this.sizelimit) {
                bl = true;
            }
            return bl;
        }
        if (this.cmp == 1) {
            boolean bl = false;
            if (file2.length() > this.sizelimit) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (file2.length() == this.sizelimit) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.size = -1;
        this.multiplier = 1L;
        this.sizelimit = -1;
        this.cmp = 2;
    }

    public SizeSelector() {
        this.this();
    }

    public static class ByteUnits
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"K", "k", "kilo", "KILO", "Ki", "KI", "ki", "kibi", "KIBI", "M", "m", "mega", "MEGA", "Mi", "MI", "mi", "mebi", "MEBI", "G", "g", "giga", "GIGA", "Gi", "GI", "gi", "gibi", "GIBI", "T", "t", "tera", "TERA", "Ti", "TI", "ti", "tebi", "TEBI"};
        }
    }

    public static class SizeComparisons
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"less", "more", "equal"};
        }
    }
}

