/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.Set;
import org.jdesktop.jdic.browser.WebBrowser;

class MsgClient {
    private static final int MAX_RETRY = 30;
    private static final int BUFFERSIZE = 1024;
    private Selector selector = null;
    private SocketChannel channel = null;
    private int port;
    private InetSocketAddress serverAddr;
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;
    private ByteBuffer buffer;
    private CharBuffer charBuffer;
    private String sendBuffer = new String();
    private String recvBuffer = new String();

    MsgClient() {
        Charset charset = Charset.forName("ISO-8859-1");
        this.decoder = charset.newDecoder();
        this.encoder = charset.newEncoder();
        this.buffer = ByteBuffer.allocateDirect(1024);
        this.charBuffer = CharBuffer.allocate(1024);
        try {
            this.selector = Selector.open();
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(new InetSocketAddress("localhost", 0));
            this.port = serverSocketChannel.socket().getLocalPort();
            serverSocketChannel.close();
            serverSocketChannel = null;
            this.serverAddr = new InetSocketAddress("localhost", this.port);
            WebBrowser.trace("found a free port: " + this.port);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int getPort() {
        return this.port;
    }

    void connect() throws IOException, InterruptedException {
        int n;
        for (n = 0; n < 30; ++n) {
            WebBrowser.trace("connecting ... " + n);
            try {
                this.channel = SocketChannel.open();
                this.channel.configureBlocking(false);
                this.channel.connect(this.serverAddr);
                this.channel.register(this.selector, 8);
                block5: while (!this.channel.isConnected()) {
                    if (this.selector.select(1L) <= 0) continue;
                    Set<SelectionKey> set = this.selector.selectedKeys();
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                        if (!selectionKey.isConnectable()) continue;
                        if (!socketChannel.isConnectionPending()) continue block5;
                        socketChannel.finishConnect();
                        continue block5;
                    }
                }
                break;
            }
            catch (Exception exception) {
                WebBrowser.trace(exception.toString());
                this.channel.close();
                this.channel = null;
                try {
                    Thread.sleep(150L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (n == 30) {
            throw new InterruptedException("Maximum retry number reached!");
        }
        WebBrowser.trace("connected");
        this.channel.register(this.selector, 5);
    }

    void sendMessage(String string) {
        this.sendBuffer = this.sendBuffer + string + "\n";
    }

    String getMessage() {
        int n = this.recvBuffer.indexOf("\n");
        if (n >= 0) {
            String string = this.recvBuffer.substring(0, n);
            this.recvBuffer = this.recvBuffer.substring(n + 1);
            return string;
        }
        return null;
    }

    void portListening() throws IOException, InterruptedException {
        if (this.selector != null && this.selector.select(1L) > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                if (selectionKey.isReadable()) {
                    this.buffer.clear();
                    this.charBuffer.clear();
                    socketChannel.read(this.buffer);
                    this.buffer.flip();
                    this.decoder.decode(this.buffer, this.charBuffer, false);
                    this.charBuffer.flip();
                    this.recvBuffer = this.recvBuffer + this.charBuffer;
                    continue;
                }
                if (!selectionKey.isWritable() || this.sendBuffer.length() <= 0) continue;
                WebBrowser.trace("send data to socket: " + this.sendBuffer);
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.sendBuffer.getBytes());
                socketChannel.write(byteBuffer);
                this.sendBuffer = "";
            }
        }
    }
}

