/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.stringprep;

import org.jivesoftware.stringprep.IDNAException;
import org.jivesoftware.stringprep.Punycode;
import org.jivesoftware.stringprep.PunycodeException;
import org.jivesoftware.stringprep.Stringprep;
import org.jivesoftware.stringprep.StringprepException;

public class IDNA {
    public static final String ACE_PREFIX = "xn--";

    public static String toASCII(String input) throws IDNAException {
        StringBuffer o = new StringBuffer();
        StringBuffer h = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61') {
                o.append(IDNA.toASCII(h.toString(), false, true));
                o.append(c);
                h = new StringBuffer();
                continue;
            }
            h.append(c);
        }
        o.append(IDNA.toASCII(h.toString(), false, true));
        return o.toString();
    }

    public static String toASCII(String input, boolean allowUnassigned, boolean useSTD3ASCIIRules) throws IDNAException {
        char c;
        int i;
        boolean nonASCII = false;
        for (i = 0; i < input.length(); ++i) {
            c = input.charAt(i);
            if (c <= '\u007f') continue;
            nonASCII = true;
            break;
        }
        if (nonASCII) {
            try {
                input = Stringprep.nameprep(input, allowUnassigned);
            }
            catch (StringprepException e) {
                throw new IDNAException(e);
            }
        }
        if (useSTD3ASCIIRules) {
            for (i = 0; i < input.length(); ++i) {
                c = input.charAt(i);
                if (!(c <= ',' || c >= '.' && c <= '/' || c >= ':' && c <= '@' || c >= '[' && c <= '`') && (c < '{' || c > '\u007f')) continue;
                throw new IDNAException(IDNAException.CONTAINS_NON_LDH);
            }
            if (input.startsWith("-") || input.endsWith("-")) {
                throw new IDNAException(IDNAException.CONTAINS_HYPHEN);
            }
        }
        nonASCII = false;
        for (i = 0; i < input.length(); ++i) {
            c = input.charAt(i);
            if (c <= '\u007f') continue;
            nonASCII = true;
            break;
        }
        String output = input;
        if (nonASCII) {
            if (input.startsWith(ACE_PREFIX)) {
                throw new IDNAException(IDNAException.CONTAINS_ACE_PREFIX);
            }
            try {
                output = Punycode.encode(input);
            }
            catch (PunycodeException e) {
                throw new IDNAException(e);
            }
            output = ACE_PREFIX + output;
        }
        if (output.length() < 1 || output.length() > 63) {
            throw new IDNAException(IDNAException.TOO_LONG);
        }
        return output;
    }

    public static String toUnicode(String input) {
        StringBuffer o = new StringBuffer();
        StringBuffer h = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61') {
                o.append(IDNA.toUnicode(h.toString(), false, true));
                o.append(c);
                h = new StringBuffer();
                continue;
            }
            h.append(c);
        }
        o.append(IDNA.toUnicode(h.toString(), false, true));
        return o.toString();
    }

    public static String toUnicode(String input, boolean allowUnassigned, boolean useSTD3ASCIIRules) {
        String ascii;
        String output;
        String original = input;
        boolean nonASCII = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            nonASCII = true;
            break;
        }
        if (nonASCII) {
            try {
                input = Stringprep.nameprep(input, allowUnassigned);
            }
            catch (StringprepException e) {
                return original;
            }
        }
        if (!input.startsWith(ACE_PREFIX)) {
            return original;
        }
        String stored = input;
        input = input.substring(ACE_PREFIX.length());
        try {
            output = Punycode.decode(input);
        }
        catch (PunycodeException e) {
            return original;
        }
        try {
            ascii = IDNA.toASCII(output, allowUnassigned, useSTD3ASCIIRules);
        }
        catch (IDNAException e) {
            return original;
        }
        if (!ascii.equalsIgnoreCase(stored)) {
            return original;
        }
        return output;
    }
}

