/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue.operations;

import com.hazelcast.collection.impl.queue.QueueContainer;
import com.hazelcast.collection.impl.queue.operations.QueueOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;

public class TxnRollbackBackupOperation
extends QueueOperation
implements BackupOperation {
    private long itemId;
    private boolean pollOperation;

    public TxnRollbackBackupOperation() {
    }

    public TxnRollbackBackupOperation(String name, long itemId, boolean pollOperation) {
        super(name);
        this.itemId = itemId;
        this.pollOperation = pollOperation;
    }

    @Override
    public void run() throws Exception {
        QueueContainer queueContainer = this.getOrCreateContainer();
        this.response = this.pollOperation ? Boolean.valueOf(queueContainer.txnRollbackPoll(this.itemId, true)) : Boolean.valueOf(queueContainer.txnRollbackOfferBackup(this.itemId));
    }

    @Override
    public int getId() {
        return 33;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.pollOperation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.pollOperation = in.readBoolean();
    }
}

