/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.moho.media.output;

import com.voxeo.moho.media.output.AudibleResource;
import com.voxeo.moho.media.output.AudioURIResource;
import com.voxeo.moho.media.output.TextToSpeechResource;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.CodecConstants;
import javax.media.mscontrol.mediagroup.FileFormatConstants;
import javax.media.mscontrol.resource.RTC;
import org.apache.log4j.Logger;

public class OutputCommand
implements Parameters,
Cloneable {
    private static final Logger LOG = Logger.getLogger(OutputCommand.class);
    protected AudibleResource[] _resources;
    protected BehaviorIfBusy _behavior = BehaviorIfBusy.QUEUE;
    protected BargeinType _bargein = BargeinType.NONE;
    protected String _voiceName;
    protected String _language;
    protected long _maxtime = -1L;
    protected long _offset = 0L;
    protected int _volumeUnit = 3;
    protected Value _codec = CodecConstants.INFERRED;
    protected Value _format = FileFormatConstants.INFERRED;
    protected long _repeatInterval = 0L;
    protected int _repeatTimes = 1;
    protected int _jumpPlaylistIncrement = 1;
    protected long _jumpTime = 5000L;
    protected boolean _startInPausedMode = false;
    protected Parameters _parameters;
    protected RTC[] _rtcs;
    protected Map<Parameter, Object> _parametersExt = new HashMap<Parameter, Object>();
    protected Set<RTC> _rtcsExt = new HashSet<RTC>();

    public OutputCommand(String textOrURL) {
        if (textOrURL == null || textOrURL.length() == 0) {
            throw new IllegalArgumentException();
        }
        URL url = null;
        try {
            url = new URL(textOrURL);
        }
        catch (IllegalArgumentException ex) {
            LOG.debug((Object)("" + ex.getMessage()));
        }
        catch (MalformedURLException e) {
            LOG.debug((Object)("" + e.getMessage()));
        }
        this._resources = url != null ? new AudibleResource[]{new AudioURIResource(URI.create(textOrURL))} : new AudibleResource[]{new TextToSpeechResource(textOrURL)};
    }

    public OutputCommand(AudibleResource resource) {
        if (resource != null) {
            this._resources = new AudibleResource[]{resource};
        }
    }

    public OutputCommand(AudibleResource[] resources) {
        this._resources = resources;
    }

    public void setAudibleResource(AudibleResource[] resources) {
        this._resources = resources;
    }

    public BehaviorIfBusy getBehavior() {
        return this._behavior;
    }

    public void setBahavior(BehaviorIfBusy behavior) {
        this._behavior = behavior;
    }

    public AudibleResource[] getAudibleResources() {
        return this._resources;
    }

    public BargeinType getBargeinType() {
        return this._bargein;
    }

    public void setBargeinType(BargeinType bargein) {
        this._bargein = bargein;
    }

    public long getMaxtime() {
        return this._maxtime;
    }

    public void setMaxtime(long maxtime) {
        if (maxtime <= 0L) {
            throw new IllegalArgumentException("Timeout must be a positive integer.");
        }
        this._maxtime = maxtime;
    }

    public long getStartingOffset() {
        return this._offset;
    }

    public void setStartingOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset can not be a negative integer.");
        }
        this._offset = offset;
    }

    public int getVolumeUnit() {
        return this._volumeUnit;
    }

    public void setVolumeUnit(int unit) {
        this._volumeUnit = unit;
    }

    public Value getCodec() {
        return this._codec;
    }

    public void setCodec(Value codec) {
        this._codec = codec;
    }

    public Value getFormat() {
        return this._format;
    }

    public void setFormat(Value format) {
        this._format = format;
    }

    public long getRepeatInterval() {
        return this._repeatInterval;
    }

    public void setRepeatInterval(long interval) {
        if (interval < 0L) {
            throw new IllegalArgumentException("Repeat Interval can not be a negative integer.");
        }
        this._repeatInterval = interval;
    }

    public int getJumpPlaylistIncrement() {
        return this._jumpPlaylistIncrement;
    }

    public void setJumpPlaylistIncrement(int jumpPlaylistIncrement) {
        if (jumpPlaylistIncrement <= 0) {
            throw new IllegalArgumentException("Jump Playlist Increment must be a positive integer.");
        }
        this._jumpPlaylistIncrement = jumpPlaylistIncrement;
    }

    public long getMoveTime() {
        return this._jumpTime;
    }

    public void setMoveTime(long jumpTime) {
        if (jumpTime < 0L) {
            throw new IllegalArgumentException("Time can not be a negative integer.");
        }
        this._jumpTime = jumpTime;
    }

    public boolean isStartInPausedMode() {
        return this._startInPausedMode;
    }

    public void setStartInPausedMode(boolean startInPausedMode) {
        this._startInPausedMode = startInPausedMode;
    }

    @Deprecated
    public Parameters getParameters() {
        return this._parameters;
    }

    @Deprecated
    public void setParameters(Parameters parameters) {
        this._parameters = parameters;
    }

    @Deprecated
    public RTC[] getRtcs() {
        return this._rtcs;
    }

    @Deprecated
    public void setRtcs(RTC[] rtcs) {
        this._rtcs = rtcs;
    }

    public boolean addRTC(RTC rtc) {
        return this._rtcsExt.add(rtc);
    }

    public boolean addAllRTC(Collection<? extends RTC> c) {
        return this._rtcsExt.addAll(c);
    }

    public void removeAllRTC() {
        this._rtcsExt.clear();
    }

    public boolean removeRTC(Object o) {
        return this._rtcsExt.remove(o);
    }

    public Set<RTC> getAllRTC() {
        return this._rtcsExt;
    }

    public void clear() {
        this._parametersExt.clear();
    }

    public boolean containsKey(Object key) {
        return this._parametersExt.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._parametersExt.containsValue(value);
    }

    public Set<Map.Entry<Parameter, Object>> entrySet() {
        return this._parametersExt.entrySet();
    }

    public Object get(Object key) {
        return this._parametersExt.get(key);
    }

    public boolean isEmpty() {
        return this._parametersExt.isEmpty();
    }

    public Set<Parameter> keySet() {
        return this._parametersExt.keySet();
    }

    public Object put(Parameter key, Object value) {
        return this._parametersExt.put(key, value);
    }

    public void putAll(Map<? extends Parameter, ? extends Object> t) {
        this._parametersExt.putAll(t);
    }

    public Object remove(Object key) {
        return this._parametersExt.remove(key);
    }

    public int size() {
        return this._parametersExt.size();
    }

    public Collection<Object> values() {
        return this._parametersExt.values();
    }

    public int getRepeatTimes() {
        return this._repeatTimes;
    }

    public void setRepeatTimes(int repeatTimes) {
        this._repeatTimes = repeatTimes;
    }

    public String getVoiceName() {
        return this._voiceName;
    }

    public void setVoiceName(String voiceName) {
        this._voiceName = voiceName;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static enum BargeinType {
        DTMF,
        SPEECH,
        ANY,
        NONE;

    }

    public static enum BehaviorIfBusy {
        QUEUE,
        STOP,
        ERROR;

    }
}

