/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.txn.ClientTxnPortableHook;
import com.hazelcast.client.txn.TransactionRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionAccessor;
import java.io.IOException;

public class CommitTransactionRequest
extends TransactionRequest {
    boolean prepareAndCommit = false;

    public CommitTransactionRequest() {
    }

    public CommitTransactionRequest(int clientThreadId, boolean prepareAndCommit) {
        super(clientThreadId);
        this.prepareAndCommit = prepareAndCommit;
    }

    @Override
    public Object innerCall() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext transactionContext = endpoint.getTransactionContext();
        if (this.prepareAndCommit) {
            transactionContext.commitTransaction();
        } else {
            Transaction transaction = TransactionAccessor.getTransaction(transactionContext);
            transaction.commit();
        }
        endpoint.setTransactionContext(null);
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeBoolean("pc", this.prepareAndCommit);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.prepareAndCommit = reader.readBoolean("pc");
    }
}

