/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Context;
import com.install4j.api.ProgressInterface;
import com.install4j.api.StartupHandler;
import com.install4j.api.UninstallAction;
import com.install4j.api.Util;
import com.install4j.runtime.installer.Common;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallationProperties;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.QuietProgressInterface;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.fileinst.FileInstaller;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.frontend.UninstallerWizard;
import com.install4j.runtime.installer.platform.PlatformSpecificInstaller;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.ResourceHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class Uninstaller {
    private static boolean quiet = false;
    private static ContextImpl context;

    private Uninstaller() {
    }

    public List getUndeletedFiles() {
        if (InstallerUtil.isWindows()) {
            return new ArrayList();
        }
        return FileInstaller.getInstance().getUndeletedFiles();
    }

    public List getUndeletedDirs() {
        if (InstallerUtil.isWindows()) {
            return new ArrayList();
        }
        return FileInstaller.getInstance().getUndeletedDirs();
    }

    public void uninstall(ProgressInterface progressInterface) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        UninstallAction uninstallAction = null;
        UninstallAction uninstallAction2 = null;
        try {
            uninstallAction = (UninstallAction)InstallerUtil.instantiateAction(installerConfig.getUninstallPreActionClass());
            uninstallAction2 = (UninstallAction)InstallerUtil.instantiateAction(installerConfig.getUninstallPostActionClass());
        }
        catch (Exception exception) {
            GUIHelper.showMessage(null, exception.getMessage(), 0);
            System.exit(1);
        }
        int n = uninstallAction == null ? 0 : uninstallAction.getPercentOfTotalInstallation();
        int n2 = uninstallAction2 == null ? 0 : uninstallAction2.getPercentOfTotalInstallation();
        ProgressAdapter progressAdapter = new ProgressAdapter(progressInterface, 0, n);
        ProgressAdapter progressAdapter2 = new ProgressAdapter(progressInterface, n, 100 - n2);
        ProgressAdapter progressAdapter3 = new ProgressAdapter(progressInterface, 100 - n2, 100);
        try {
            File file = Uninstaller.getInstallationDirectory();
            if (uninstallAction != null && !uninstallAction.performAction(context, progressAdapter)) {
                System.exit(1);
            }
            PlatformSpecificInstaller.doUninstallation(file, progressInterface);
            FileInstaller fileInstaller = FileInstaller.getInstance();
            Iterator iterator = installerConfig.getUninstallDeleteEntries().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                fileInstaller.deleteFile(new File(file, string));
            }
            fileInstaller.uninstall(progressAdapter2);
            if (uninstallAction2 != null) {
                uninstallAction2.performAction(context, progressAdapter3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "An error occurred:\n" + exception.getLocalizedMessage());
            progressInterface.showFailure(string);
            System.exit(1);
        }
        if (InstallerUtil.isMacOS()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private static File getInstallationDirectory() {
        return new File(ResourceHelper.getRuntimeDir(), "..").getAbsoluteFile();
    }

    private static Uninstaller initializeUninstaller() {
        Uninstaller uninstaller = new Uninstaller();
        if (!quiet) {
            FileResourceBundle fileResourceBundle = Messages.getMessages();
            String string = MessageFormat.format(fileResourceBundle.getString("ConfirmUninstall"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
            int n = 0;
            try {
                n = GUIHelper.showOptionDialog(null, string, new String[]{fileResourceBundle.getString("ButtonYes"), fileResourceBundle.getString("ButtonNo")}, 3);
            }
            catch (Throwable throwable) {
                if (!Util.isWindows()) {
                    System.err.println("This uninstaller needs access to an X Server.");
                    System.err.println("If this is not possible, you can run the uninstaller in unattended mode");
                    System.err.println("by passing the argument -q to the installer.");
                    System.exit(1);
                }
                throw new RuntimeException(throwable);
            }
            if (n != 0) {
                System.exit(0);
            }
            Installer.checkSudo();
        }
        return uninstaller;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (((String)object).equals("-q")) {
                    quiet = true;
                    GUIHelper.setQuiet(true);
                    continue;
                }
                InstallerUtil.checkPropertyPassOn((String)object);
            }
            if (Common.checkAdmin()) {
                File file = Uninstaller.getInstallationDirectory();
                context = new ContextImpl(file, quiet);
                if (!Uninstaller.checkStartupHandler(context)) {
                    System.exit(1);
                }
                object = Uninstaller.initializeUninstaller();
                InstallationProperties installationProperties = new InstallationProperties(Uninstaller.getInstallationDirectory());
                if (Common.checkRunningProcesses(installationProperties, quiet, "UninstallAppRunningError")) {
                    if (quiet) {
                        ((Uninstaller)object).uninstall(new QuietProgressInterface(false));
                        System.exit(0);
                    } else {
                        SwingUtilities.invokeLater(new Runnable((Uninstaller)object){
                            private final /* synthetic */ Uninstaller val$uninstaller;
                            {
                                this.val$uninstaller = uninstaller;
                            }

                            public void run() {
                                try {
                                    UninstallerWizard uninstallerWizard = new UninstallerWizard(this.val$uninstaller);
                                    uninstallerWizard.showFrame();
                                }
                                catch (Throwable throwable) {
                                    Installer.reportExeption(throwable, false);
                                    System.exit(1);
                                }
                            }
                        });
                    }
                } else {
                    if (quiet) {
                        System.err.println("The application is running. Please close all instances and run the uninstaller again.");
                    }
                    System.exit(1);
                }
            } else {
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            Installer.reportExeption(throwable, quiet);
            System.exit(1);
        }
    }

    private static boolean checkStartupHandler(Context context) {
        try {
            Object object = InstallerUtil.instantiateClass(InstallerConfig.getCurrentInstance().getInitHandlerClass(), "startup handler", null);
            if (object != null && object instanceof StartupHandler) {
                StartupHandler startupHandler = (StartupHandler)object;
                return startupHandler.prepareUninstaller(context);
            }
        }
        catch (Exception exception) {
            GUIHelper.showMessage(null, exception.getMessage(), 0);
            System.exit(1);
        }
        return true;
    }

    public static boolean checkReboot() {
        if (InstallerUtil.isWindows() && (InstallerConfig.getCurrentInstance().getWindowsSpecificConfig().isRebootUninstaller() || context.isRebootAfterFinish())) {
            if (quiet) {
                Misc.reboot();
            } else {
                FileResourceBundle fileResourceBundle = Messages.getMessages();
                int n = GUIHelper.showOptionDialog(null, MessageFormat.format(fileResourceBundle.getString("UninstalledAndNeedsRestart"), InstallerConfig.getCurrentInstance().getApplicationName()), new String[]{fileResourceBundle.getString("ButtonYes"), fileResourceBundle.getString("ButtonNo")}, 3);
                if (n == 0) {
                    Misc.reboot();
                }
            }
            return true;
        }
        return false;
    }
}

