/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.OggSpeexWriter;
import org.xiph.speex.PcmWaveWriter;
import org.xiph.speex.RawWriter;
import org.xiph.speex.SpeexEncoder;

public class JSpeexEnc {
    public static final String VERSION = "Java Speex Command Line Encoder v0.9.7 ($Revision: 1.5 $)";
    public static final String COPYRIGHT = "Copyright (C) 2002-2004 Wimba S.A.";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    protected int printlevel = 1;
    public static final int FILE_FORMAT_RAW = 0;
    public static final int FILE_FORMAT_OGG = 1;
    public static final int FILE_FORMAT_WAVE = 2;
    protected int srcFormat = 1;
    protected int destFormat = 2;
    protected int mode = -1;
    protected int quality = 8;
    protected int complexity = 3;
    protected int nframes = 1;
    protected int bitrate = -1;
    protected int sampleRate = -1;
    protected int channels = 1;
    protected float vbr_quality = -1.0f;
    protected boolean vbr = false;
    protected boolean vad = false;
    protected boolean dtx = false;
    protected String srcFile;
    protected String destFile;

    public static void main(String[] args) throws IOException {
        JSpeexEnc encoder = new JSpeexEnc();
        if (encoder.parseArgs(args)) {
            encoder.encode();
        }
    }

    public boolean parseArgs(String[] args) {
        if (args.length < 2) {
            if (args.length == 1 && (args[0].equalsIgnoreCase("-v") || args[0].equalsIgnoreCase("--version"))) {
                JSpeexEnc.version();
                return false;
            }
            JSpeexEnc.usage();
            return false;
        }
        this.srcFile = args[args.length - 2];
        this.destFile = args[args.length - 1];
        this.srcFormat = this.srcFile.toLowerCase().endsWith(".wav") ? 2 : 0;
        this.destFormat = this.destFile.toLowerCase().endsWith(".spx") ? 1 : (this.destFile.toLowerCase().endsWith(".wav") ? 2 : 0);
        for (int i = 0; i < args.length - 2; ++i) {
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
                JSpeexEnc.usage();
                return false;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("--version")) {
                JSpeexEnc.version();
                return false;
            }
            if (args[i].equalsIgnoreCase("--verbose")) {
                this.printlevel = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("--quiet")) {
                this.printlevel = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n") || args[i].equalsIgnoreCase("-nb") || args[i].equalsIgnoreCase("--narrowband")) {
                this.mode = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("-w") || args[i].equalsIgnoreCase("-wb") || args[i].equalsIgnoreCase("--wideband")) {
                this.mode = 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u") || args[i].equalsIgnoreCase("-uwb") || args[i].equalsIgnoreCase("--ultra-wideband")) {
                this.mode = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-q") || args[i].equalsIgnoreCase("--quality")) {
                try {
                    this.vbr_quality = Float.parseFloat(args[++i]);
                    this.quality = (int)this.vbr_quality;
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexEnc.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("--complexity")) {
                try {
                    this.complexity = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexEnc.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("--nframes")) {
                try {
                    this.nframes = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexEnc.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("--vbr")) {
                this.vbr = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--vad")) {
                this.vad = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--dtx")) {
                this.dtx = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("--rate")) {
                try {
                    this.sampleRate = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JSpeexEnc.usage();
                    return false;
                }
            }
            if (args[i].equalsIgnoreCase("--stereo")) {
                this.channels = 2;
                continue;
            }
            JSpeexEnc.usage();
            return false;
        }
        return true;
    }

    public static void usage() {
        JSpeexEnc.version();
        System.out.println("");
        System.out.println("Usage: JSpeexEnc [options] input_file output_file");
        System.out.println("Where:");
        System.out.println("  input_file can be:");
        System.out.println("    filename.wav  a PCM wav file");
        System.out.println("    filename.*    a raw PCM file (any extension other than .wav)");
        System.out.println("  output_file can be:");
        System.out.println("    filename.spx  an Ogg Speex file");
        System.out.println("    filename.wav  a Wave Speex file (beta!!!)");
        System.out.println("    filename.*    a raw Speex file");
        System.out.println("Options: -h, --help     This help");
        System.out.println("         -v, --version  Version information");
        System.out.println("         --verbose      Print detailed information");
        System.out.println("         --quiet        Print minimal information");
        System.out.println("         -n, -nb        Consider input as Narrowband (8kHz)");
        System.out.println("         -w, -wb        Consider input as Wideband (16kHz)");
        System.out.println("         -u, -uwb       Consider input as Ultra-Wideband (32kHz)");
        System.out.println("         --quality n    Encoding quality (0-10) default 8");
        System.out.println("         --complexity n Encoding complexity (0-10) default 3");
        System.out.println("         --nframes n    Number of frames per Ogg packet, default 1");
        System.out.println("         --vbr          Enable varible bit-rate (VBR)");
        System.out.println("         --vad          Enable voice activity detection (VAD)");
        System.out.println("         --dtx          Enable file based discontinuous transmission (DTX)");
        System.out.println("         if the input file is raw PCM (not a Wave file)");
        System.out.println("         --rate n       Sampling rate for raw input");
        System.out.println("         --stereo       Consider input as stereo");
        System.out.println("More information is available from: http://jspeex.sourceforge.net/");
        System.out.println("This code is a Java port of the Speex codec: http://www.speex.org/");
    }

    public static void version() {
        System.out.println(VERSION);
        System.out.println("using Java Speex Encoder v0.9.7 ($Revision: 1.6 $)");
        System.out.println(COPYRIGHT);
    }

    public void encode() throws IOException {
        this.encode(new File(this.srcFile), new File(this.destFile));
    }

    public void encode(File srcPath, File destPath) throws IOException {
        AudioFileWriter writer;
        byte[] temp = new byte[2560];
        int HEADERSIZE = 8;
        String RIFF = "RIFF";
        String WAVE = "WAVE";
        String FORMAT = "fmt ";
        String DATA = "data";
        boolean WAVE_FORMAT_PCM = true;
        if (this.printlevel <= 1) {
            JSpeexEnc.version();
        }
        if (this.printlevel <= 0) {
            System.out.println("");
        }
        if (this.printlevel <= 0) {
            System.out.println("Input File: " + srcPath);
        }
        DataInputStream dis = new DataInputStream(new FileInputStream(srcPath));
        if (this.srcFormat == 2) {
            dis.readFully(temp, 0, 12);
            if (!"RIFF".equals(new String(temp, 0, 4)) && !"WAVE".equals(new String(temp, 8, 4))) {
                System.err.println("Not a WAVE file");
                return;
            }
            dis.readFully(temp, 0, 8);
            String chunk = new String(temp, 0, 4);
            int size = JSpeexEnc.readInt(temp, 4);
            while (!chunk.equals("data")) {
                dis.readFully(temp, 0, size);
                if (chunk.equals("fmt ")) {
                    if (JSpeexEnc.readShort(temp, 0) != 1) {
                        System.err.println("Not a PCM file");
                        return;
                    }
                    this.channels = JSpeexEnc.readShort(temp, 2);
                    this.sampleRate = JSpeexEnc.readInt(temp, 4);
                    if (JSpeexEnc.readShort(temp, 14) != 16) {
                        System.err.println("Not a 16 bit file " + JSpeexEnc.readShort(temp, 18));
                        return;
                    }
                    if (this.printlevel <= 0) {
                        System.out.println("File Format: PCM wave");
                        System.out.println("Sample Rate: " + this.sampleRate);
                        System.out.println("Channels: " + this.channels);
                    }
                }
                dis.readFully(temp, 0, 8);
                chunk = new String(temp, 0, 4);
                size = JSpeexEnc.readInt(temp, 4);
            }
            if (this.printlevel <= 0) {
                System.out.println("Data size: " + size);
            }
        } else {
            if (this.sampleRate < 0) {
                switch (this.mode) {
                    case 0: {
                        this.sampleRate = 8000;
                        break;
                    }
                    case 1: {
                        this.sampleRate = 16000;
                        break;
                    }
                    case 2: {
                        this.sampleRate = 32000;
                        break;
                    }
                    default: {
                        this.sampleRate = 8000;
                    }
                }
            }
            if (this.printlevel <= 0) {
                System.out.println("File format: Raw audio");
                System.out.println("Sample rate: " + this.sampleRate);
                System.out.println("Channels: " + this.channels);
                System.out.println("Data size: " + srcPath.length());
            }
        }
        if (this.mode < 0) {
            if (this.sampleRate < 100) {
                this.sampleRate *= 1000;
            }
            this.mode = this.sampleRate < 12000 ? 0 : (this.sampleRate < 24000 ? 1 : 2);
        }
        SpeexEncoder speexEncoder = new SpeexEncoder();
        speexEncoder.init(this.mode, this.quality, this.sampleRate, this.channels);
        if (this.complexity > 0) {
            speexEncoder.getEncoder().setComplexity(this.complexity);
        }
        if (this.bitrate > 0) {
            speexEncoder.getEncoder().setBitRate(this.bitrate);
        }
        if (this.vbr) {
            speexEncoder.getEncoder().setVbr(this.vbr);
            if (this.vbr_quality > 0.0f) {
                speexEncoder.getEncoder().setVbrQuality(this.vbr_quality);
            }
        }
        if (this.vad) {
            speexEncoder.getEncoder().setVad(this.vad);
        }
        if (this.dtx) {
            speexEncoder.getEncoder().setDtx(this.dtx);
        }
        if (this.printlevel <= 0) {
            System.out.println("");
            System.out.println("Output File: " + destPath);
            System.out.println("File format: Ogg Speex");
            System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
            System.out.println("Quality: " + (this.vbr ? this.vbr_quality : (float)this.quality));
            System.out.println("Complexity: " + this.complexity);
            System.out.println("Frames per packet: " + this.nframes);
            System.out.println("Varible bitrate: " + this.vbr);
            System.out.println("Voice activity detection: " + this.vad);
            System.out.println("Discontinouous Transmission: " + this.dtx);
        }
        if (this.destFormat == 1) {
            writer = new OggSpeexWriter(this.mode, this.sampleRate, this.channels, this.nframes, this.vbr);
        } else if (this.destFormat == 2) {
            this.nframes = PcmWaveWriter.WAVE_FRAME_SIZES[this.mode - 1][this.channels - 1][this.quality];
            writer = new PcmWaveWriter(this.mode, this.quality, this.sampleRate, this.channels, this.nframes, this.vbr);
        } else {
            writer = new RawWriter();
        }
        writer.open(destPath);
        writer.writeHeader("Encoded with: Java Speex Command Line Encoder v0.9.7 ($Revision: 1.5 $)");
        int pcmPacketSize = 2 * this.channels * speexEncoder.getFrameSize();
        try {
            while (true) {
                dis.readFully(temp, 0, this.nframes * pcmPacketSize);
                for (int i = 0; i < this.nframes; ++i) {
                    speexEncoder.processData(temp, i * pcmPacketSize, pcmPacketSize);
                }
                int encsize = speexEncoder.getProcessedData(temp, 0);
                if (encsize <= 0) continue;
                writer.writePacket(temp, 0, encsize);
            }
        }
        catch (EOFException e) {
            writer.close();
            dis.close();
            return;
        }
    }

    protected static int readInt(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | data[offset + 3] << 24;
    }

    protected static int readShort(byte[] data, int offset) {
        return data[offset] & 0xFF | data[offset + 1] << 8;
    }
}

