/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.MapBackedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualExecutorService
extends AbstractExecutorService {
    private final Executor e;
    private final ExecutorService s;
    final Object startStopLock = new Object();
    volatile boolean shutdown;
    Set<Thread> activeThreads = new MapBackedSet(new IdentityHashMap());

    public VirtualExecutorService(Executor parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (parent instanceof ExecutorService) {
            this.e = null;
            this.s = (ExecutorService)parent;
        } else {
            this.e = parent;
            this.s = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.startStopLock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.startStopLock;
        synchronized (object) {
            return this.shutdown && this.activeThreads.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.isTerminated()) {
                this.shutdown();
                for (Thread t : this.activeThreads) {
                    t.interrupt();
                }
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Object object = this.startStopLock;
        synchronized (object) {
            while (!this.isTerminated()) {
                this.startStopLock.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
            }
            return this.isTerminated();
        }
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (this.shutdown) {
            throw new RejectedExecutionException();
        }
        if (this.s != null) {
            this.s.execute(new ChildExecutorRunnable(command));
        } else {
            this.e.execute(new ChildExecutorRunnable(command));
        }
    }

    private class ChildExecutorRunnable
    implements Runnable {
        private final Runnable runnable;

        ChildExecutorRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Thread thread = Thread.currentThread();
            Object object2 = VirtualExecutorService.this.startStopLock;
            synchronized (object2) {
                VirtualExecutorService.this.activeThreads.add(thread);
            }
            try {
                this.runnable.run();
                Object var5_4 = null;
                object = VirtualExecutorService.this.startStopLock;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Object object3 = VirtualExecutorService.this.startStopLock;
                synchronized (object3) {
                    boolean removed = VirtualExecutorService.this.activeThreads.remove(thread);
                    assert (removed);
                    if (VirtualExecutorService.this.isTerminated()) {
                        VirtualExecutorService.this.startStopLock.notifyAll();
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                boolean removed = VirtualExecutorService.this.activeThreads.remove(thread);
                assert (removed);
                if (VirtualExecutorService.this.isTerminated()) {
                    VirtualExecutorService.this.startStopLock.notifyAll();
                }
            }
        }
    }
}

