/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.io.WriterOutputStream;
import com.voxeo.utils.Closer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.log4j.Logger;

public class IO {
    private static final Logger log = Logger.getLogger(IO.class);
    public static final int DEFAULT_BUFFER_SIZE = 8124;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLines(URL url) throws IOException {
        String[] stringArray;
        BufferedReader in = null;
        LinkedList<String> r = new LinkedList<String>();
        try {
            String s = null;
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((s = in.readLine()) != null) {
                r.add(s);
            }
            stringArray = r.toArray(new String[r.size()]);
        }
        catch (Throwable throwable) {
            Closer.close(in);
            throw throwable;
        }
        Closer.close(in);
        return stringArray;
    }

    public static String[] getLines(File file) throws IOException {
        return IO.getLines(file.toURL());
    }

    public static String getContentsAsString(File file) throws IOException {
        return FileUtils.readFileToString((File)file);
    }

    public static void save(File file, byte[] contents) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])contents);
    }

    public static void save(File file, String content, String encoding) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content, (String)encoding);
    }

    public static void save(File file, String content) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentsAsString(URL url) throws IOException {
        String string;
        BufferedReader in = null;
        try {
            String s = null;
            StringBuilder buffer = new StringBuilder();
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((s = in.readLine()) != null) {
                buffer.append(s);
                buffer.append('\n');
            }
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            Closer.close(in);
            throw throwable;
        }
        Closer.close(in);
        return string;
    }

    public static String toString(InputStream istream) throws IOException {
        return IOUtils.toString((InputStream)istream);
    }

    public static String toString(InputStream istream, String encoding) throws IOException {
        return IOUtils.toString((InputStream)istream, (String)encoding);
    }

    public static String toString(Reader in) throws IOException {
        return IOUtils.toString((Reader)in);
    }

    public static boolean isLocalIp(String ip) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress ia = addrs.nextElement();
                    String ipAddr = ia.getHostAddress();
                    if (!ipAddr.equals(ip)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            log.error((Object)"Unable to retrieve local IP address", (Throwable)e);
        }
        return false;
    }

    public static OutputStream tee(OutputStream ... streams) {
        return IO.doTee(streams, 0);
    }

    public static Writer tee(Writer ... streams) {
        return IO.doTee(streams, 0);
    }

    private static OutputStream doTee(OutputStream[] streams, int index) {
        if (index < streams.length && index >= 0) {
            OutputStream stream = streams[index];
            if (index + 1 < streams.length) {
                return new TeeOutputStream(stream, IO.doTee(streams, index + 1));
            }
            return stream;
        }
        throw new IllegalArgumentException("bad index: " + index);
    }

    private static Writer doTee(Writer[] streams, int index) {
        if (index < streams.length && index >= 0) {
            Writer stream = streams[index];
            if (index + 1 < streams.length) {
                return new OutputStreamWriter((OutputStream)new TeeOutputStream((OutputStream)new WriterOutputStream(stream), (OutputStream)new WriterOutputStream(IO.doTee(streams, index + 1))));
            }
            return stream;
        }
        throw new IllegalArgumentException("bad index: " + index);
    }
}

