/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.exceptions.InputException;
import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public class Hashes {
    private static final Loggerf log;
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA";
    private static final char[] HEX_CHARS;
    private static final int HEX_BASELENGTH = 128;
    private static final byte[] HEX_NUMBER_TABLE;

    public static byte[] sha1(byte[] input) {
        return Hashes.encode(input, SHA1);
    }

    public static byte[] sha1(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        return Hashes.sha1(input.getBytes());
    }

    public static byte[] md5(byte[] input) {
        return Hashes.encode(input, MD5);
    }

    public static byte[] md5(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        return Hashes.md5(input.getBytes());
    }

    public static byte[] md5(String input, String encoding) {
        try {
            return Hashes.md5(input.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new InputException("unsupported character encoding: %s", encoding, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5(File filename) throws IOException {
        byte[] byArray;
        MessageDigest digest = Hashes.createMessageDigest(MD5);
        BufferedInputStream fis = null;
        try {
            int read;
            fis = new BufferedInputStream(new FileInputStream(filename));
            while ((read = ((InputStream)fis).read()) != -1) {
                digest.update((byte)read);
            }
            byArray = digest.digest();
        }
        catch (Throwable throwable) {
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(fis);
        return byArray;
    }

    public static String md5hex(byte[] input) {
        return Hashes.asHex(Hashes.md5(input));
    }

    public static String md5hex(String input) {
        return Hashes.asHex(Hashes.md5(input));
    }

    public static String md5hex(String input, String encoding) {
        return Hashes.asHex(Hashes.md5(input, encoding));
    }

    public static String md5hex(File input) throws IOException {
        return Hashes.asHex(Hashes.md5(input));
    }

    public static String sha64(byte[] input) {
        return Hashes.base64Encode(Hashes.sha1(input));
    }

    public static String sha64(String input) {
        return Hashes.base64Encode(Hashes.sha1(input));
    }

    public static String sha1Hex(String input) {
        return Hashes.asHex(Hashes.sha1(input));
    }

    public static String asHex(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    public static byte[] fromHex(String encoded) {
        if (encoded == null) {
            return null;
        }
        int lengthData = encoded.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        for (int i = 0; i < lengthDecode; ++i) {
            int temp2;
            int temp1;
            char tempChar = binaryData[i * 2];
            int n = temp1 = tempChar < '\u0080' ? HEX_NUMBER_TABLE[tempChar] : -1;
            if (temp1 == -1) {
                return null;
            }
            tempChar = binaryData[i * 2 + 1];
            int n2 = temp2 = tempChar < '\u0080' ? HEX_NUMBER_TABLE[tempChar] : -1;
            if (temp2 == -1) {
                return null;
            }
            decodedData[i] = (byte)(temp1 << 4 | temp2);
        }
        return decodedData;
    }

    public static String base64Encode(byte[] buf) {
        return Strings.encode(Base64.encodeBase64((byte[])buf), "UTF-8");
    }

    public static String base64Decode(byte[] buf) {
        return Strings.encode(Base64.decodeBase64((byte[])buf), "UTF-8");
    }

    public static byte[] base64Decode(String enc) {
        return Base64.decodeBase64((byte[])Strings.getBytes(enc, "UTF-8"));
    }

    private static byte[] encode(byte[] input, String encoding) {
        if (input == null || input.length == 0) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        MessageDigest md = Hashes.createMessageDigest(encoding);
        md.update(input);
        return md.digest();
    }

    private static MessageDigest createMessageDigest(String encoding) {
        try {
            MessageDigest md = MessageDigest.getInstance(encoding);
            return md;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("%s algorithm cannot be found!", encoding);
            throw new IllegalStateException("Failed to encode input", e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(Hashes.sha64("test123"));
        System.out.println(Hashes.sha64("p00p00"));
        System.out.println(Hashes.md5hex("blahpw".getBytes("UTF-8")));
    }

    static {
        int i;
        log = Loggerf.getLogger(Hashes.class);
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_NUMBER_TABLE = new byte[128];
        for (i = 0; i < 128; ++i) {
            Hashes.HEX_NUMBER_TABLE[i] = -1;
        }
        for (i = 57; i >= 48; --i) {
            Hashes.HEX_NUMBER_TABLE[i] = (byte)(i - 48);
        }
        for (i = 70; i >= 65; --i) {
            Hashes.HEX_NUMBER_TABLE[i] = (byte)(i - 65 + 10);
        }
        for (i = 102; i >= 97; --i) {
            Hashes.HEX_NUMBER_TABLE[i] = (byte)(i - 97 + 10);
        }
    }
}

