/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class Dates {
    public static final DateTimeZone GMT = DateTimeZone.forID((String)"GMT");
    public static final DateTimeZone UTC = DateTimeZone.forID((String)"UTC");
    public static final String FULL_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_2 = "yyyyMMdd";
    private static int[] calendarFields = new int[]{1, 2, 5, 11, 12, 13, 14};

    public static Date getDate(int ... yearMonthDayHourMinuteSecondMillsecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        for (int i = 0; i < yearMonthDayHourMinuteSecondMillsecond.length; ++i) {
            calendar.set(calendarFields[i], yearMonthDayHourMinuteSecondMillsecond[i]);
        }
        return calendar.getTime();
    }

    public static Timestamp getTimestamp(int ... yearMonthDayHourMinuteSecondMillsecond) {
        return new Timestamp(Dates.getDate(yearMonthDayHourMinuteSecondMillsecond).getTime());
    }

    public static DateTime getDateTime(int ... yearMonthDayHourMinuteSecondMillsecond) {
        return new DateTime((Object)Dates.getDate(yearMonthDayHourMinuteSecondMillsecond));
    }

    public static DateTime getDateTime(String date) {
        return Dates.getDateTime(date, DateTimeZone.getDefault());
    }

    public static DateTime getDateTime(String date, DateTimeZone zone) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_2);
        format.setTimeZone(zone.toTimeZone());
        return Dates.getDateTime(date, format);
    }

    public static DateTime make(String s) {
        return Dates.getDateTime(s);
    }

    public static DateTime make(String s, DateTimeZone zone) {
        return Dates.getDateTime(s, zone);
    }

    public static DateTime getDateTime(String date, String formatString) {
        return Dates.getDateTime(date, new SimpleDateFormat(formatString));
    }

    public static DateTime getDateTime(String date, DateFormat format) {
        try {
            Date r = format.parse(date);
            return new DateTime((Object)r);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing date", e);
        }
    }

    public static String format(String fmt, Date date) {
        SimpleDateFormat format = new SimpleDateFormat(fmt);
        return format.format(date);
    }

    public static String format(String fmt, ReadableDateTime date) {
        return Dates.format(fmt, date.toDateTime().toDate());
    }

    public static int daysBetween(ReadableInstant lhs, ReadableInstant rhs) {
        return Days.daysBetween((ReadableInstant)lhs, (ReadableInstant)rhs).getDays();
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar() {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Failed to create new XMLGregorianCalendar", e);
        }
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(String dateString) {
        return Dates.createXMLGregorianCalendar(Dates.make(dateString));
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(DateTime date) {
        try {
            GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
            calendar.setTimeZone(date.getZone().toTimeZone());
            calendar.setTime(date.toDate());
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Failed to create new XMLGregorianCalendar", e);
        }
    }

    public static DateTime convertWindowsTime(long hundredNanoSecondsSinceWindowsEpoch) {
        return new DateTime(hundredNanoSecondsSinceWindowsEpoch / 10000L - 11644473600000L);
    }

    public static int secs(ReadableDuration duration) {
        return duration.toDuration().toStandardSeconds().getSeconds();
    }

    public static void main(String[] args) {
        System.out.println(Dates.convertWindowsTime(129338130752760000L));
    }
}

