/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.CompositeFilterMode;
import com.voxeo.utils.IFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFilter<T>
implements IFilter<T> {
    private CompositeFilterMode mode = CompositeFilterMode.ALL;
    private List<IFilter<T>> filters;

    public CompositeFilter(CompositeFilterMode mode, Collection<IFilter<T>> filters) {
        this.mode = mode;
        this.filters = new ArrayList<IFilter<T>>(filters);
    }

    public CompositeFilter(CompositeFilterMode mode) {
        this(mode, new ArrayList<IFilter<T>>(0));
    }

    public CompositeFilter() {
        this(CompositeFilterMode.ALL);
    }

    @Override
    public final boolean accept(T t) {
        boolean match;
        if (this.mode == CompositeFilterMode.ALL) {
            match = true;
            for (IFilter<T> filter : this.filters) {
                if (filter.accept(t)) continue;
                match = false;
                break;
            }
        } else {
            match = false;
            for (IFilter<T> filter : this.filters) {
                if (!filter.accept(t)) continue;
                match = true;
                break;
            }
            if (this.mode == CompositeFilterMode.NONE) {
                match = !match;
            }
        }
        return match;
    }

    public CompositeFilterMode getMode() {
        return this.mode;
    }

    public void setMode(CompositeFilterMode mode) {
        this.mode = mode;
    }

    public <F extends IFilter<T>> void setFilters(Collection<F> filters) {
        this.filters = new ArrayList<F>(filters);
    }

    public void clear() {
        if (this.filters != null) {
            this.filters.clear();
        }
    }

    public int size() {
        return this.filters != null ? this.filters.size() : 0;
    }

    public List<IFilter<T>> getFilters() {
        return this.filters;
    }
}

