/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sftp;

import com.voxeo.logging.Loggerf;
import com.voxeo.sftp.ISftpClient;
import com.voxeo.sftp.ISftpFileAttributes;
import com.voxeo.utils.Objects;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public abstract class BaseSftpClient
implements ISftpClient {
    protected final Loggerf log = Loggerf.getLogger(this.getClass());

    public final void rmdir(String path) throws IOException {
        this.log.debug("rmdir %s", path);
        ISftpFileAttributes attr = this.stat(path);
        if (attr == null) {
            throw new FileNotFoundException(path);
        }
        if (attr.isDirectory()) {
            List<ISftpFileAttributes> children = this.ls(path);
            for (ISftpFileAttributes child : children) {
                String childName = child.getFilename();
                if (Objects.equal(".", childName) || Objects.equal("..", childName)) continue;
                String childPath = String.format("%s/%s", path, childName);
                if (child.isDirectory()) {
                    this.rmdir(childPath);
                    continue;
                }
                this.rm(childPath);
            }
        } else {
            throw new IOException(path + " is not a directory");
        }
        this.doNonRecursiveRmDir(path);
    }

    protected abstract void doNonRecursiveRmDir(String var1) throws IOException;
}

