/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.protocols;

import java.io.BufferedReader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SentinelDecoder {
    private static final Logger Log = Logger.getLogger(SentinelDecoder.class);
    HashMap<Integer, String> clientDictionary;
    HashMap<Integer, String> serverDictionary;
    BufferedReader in;
    boolean isServer = false;

    public SentinelDecoder(BufferedReader in, boolean isServer) {
        this.isServer = isServer;
        this.in = in;
        this.clientDictionary = new HashMap(100);
        this.serverDictionary = new HashMap(100);
        this.buildDictionary();
    }

    private void buildDictionary() {
        this.serverDictionary.put(new Integer(0), "PONG");
        this.serverDictionary.put(new Integer(1), "HNDSHK");
        this.serverDictionary.put(new Integer(2), "BYE");
        this.clientDictionary.put(new Integer(0), "PING");
        this.clientDictionary.put(new Integer(1), "HNDSHK");
        this.clientDictionary.put(new Integer(2), "GO");
        this.clientDictionary.put(new Integer(3), "THX");
    }

    public boolean getMsg(int incomingCommand) {
        boolean returnValue;
        block5: {
            returnValue = false;
            String theInput = null;
            String expectedStr = "";
            try {
                theInput = this.in.readLine();
                if (this.isServer) {
                    Log.debug((Object)("Server recieved: " + theInput));
                    expectedStr = this.serverDictionary.get(new Integer(incomingCommand));
                    if (expectedStr != null) {
                        returnValue = expectedStr.equals(theInput);
                        break block5;
                    }
                    return false;
                }
                Log.debug((Object)("Client recieved: " + theInput));
                expectedStr = this.clientDictionary.get(new Integer(incomingCommand));
                if (expectedStr != null) {
                    returnValue = expectedStr.equals(theInput);
                    break block5;
                }
                return false;
            }
            catch (Exception e) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public String getCustomMsg() {
        String theInput = "";
        try {
            while (!theInput.endsWith("module>\r\n")) {
                theInput = theInput + this.in.readLine() + "\r\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theInput;
    }
}

