/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.ehcache;

import com.voxeo.utils.Maps;
import com.voxeo.utils.Properties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.jndi.ActiveMQInitialContextFactory;

public class EhcacheActiveMqInitialContextFactory
extends ActiveMQInitialContextFactory {
    public Context getInitialContext(Hashtable environment) throws NamingException {
        Properties properties;
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        String providerUrl = (String)environment.get("java.naming.provider.url");
        URI providerUri = URI.create(providerUrl);
        try {
            properties = new Properties(((Object)((Object)this)).getClass().getResource(providerUri.getPath()));
        }
        catch (IOException e) {
            throw new NamingException(e.toString());
        }
        String getQueueFactoryBindingName = (String)environment.get("getQueueConnectionFactoryBindingName");
        String replicationTopicFactoryBindingName = (String)environment.get("replicationTopicConnectionFactoryBindingName");
        String topicBindingName = (String)environment.get("replicationTopicBindingName");
        String queueBindingName = (String)environment.get("getQueueBindingName");
        String brokerKey = providerUri.getFragment();
        String brokerUrl = properties.getProperty(brokerKey);
        try {
            Object map = Maps.make("java.naming.provider.url", brokerUrl);
            ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory(new Hashtable(map));
            data.put(getQueueFactoryBindingName, connectionFactory);
            data.put(replicationTopicFactoryBindingName, connectionFactory);
            data.put(topicBindingName, this.createTopic(topicBindingName));
            data.put(queueBindingName, this.createQueue(queueBindingName));
            return this.createContext(environment, data);
        }
        catch (URISyntaxException exception) {
            throw new NamingException("Error initialisating ConnectionFactory with message " + exception.getMessage());
        }
    }
}

