/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jqql.Crypter;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.debug.DebugSwitch;
import net.sf.jqql.debug.PacketDO;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class _08Packet {
    protected static Log log = LogFactory.getLog(_08Packet.class);
    protected static final Crypter crypter = new Crypter();
    protected static final ByteBuffer bodyBuf = ByteBuffer.allocate(65535);
    protected static DebugSwitch ds = DebugSwitch.getInstance();
    protected byte[] decryptKey;
    protected byte[] fallbackDecryptKey;
    protected byte[] encryptKey;
    protected char command;
    protected char source;
    protected char sequence;
    protected byte header;
    protected QQUser user;
    protected boolean duplicated;
    protected byte[] bodyDecrypted;

    public _08Packet(byte by, char c, char c2, char c3, QQUser qQUser) {
        this.user = qQUser;
        this.source = c;
        this.command = c2;
        if (this.getPacketName().equals("Touch Login _08Packet")) {
            c3 = '\u0000';
        }
        this.sequence = c3;
        this.duplicated = false;
        this.header = by;
    }

    protected _08Packet(ByteBuffer byteBuffer, QQUser qQUser) throws PacketParseException {
        this(byteBuffer, byteBuffer.limit() - byteBuffer.position(), qQUser);
    }

    protected _08Packet(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        this.user = qQUser;
        this.parseHeader(byteBuffer);
        if (!this.validateHeader()) {
            throw new PacketParseException("\u5305\u5934\u6709\u8bef\uff0c\u629b\u5f03\u8be5\u5305: " + this.toString());
        }
        byte[] byArray = this.getBodyBytes(byteBuffer, n);
        this.bodyDecrypted = this.decryptBody(byArray);
        if (this.bodyDecrypted == null) {
            throw new PacketParseException("\u5305\u5185\u5bb9\u89e3\u6790\u51fa\u9519\uff0c\u629b\u5f03\u8be5\u5305: " + this.toString());
        }
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.bodyDecrypted);
        try {
            this.parseBody(byteBuffer2);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new PacketParseException(bufferUnderflowException.getMessage());
        }
        this.parseTail(byteBuffer);
        if (ds.isDebug()) {
            byte[] byArray2 = this.dump();
            PacketDO packetDO = new PacketDO(this.getPacketName(), byArray2, this instanceof _08InPacket, this.getHeadLength(), byArray2.length - this.getTailLength());
            ds.deliverDebugObject(packetDO);
        }
    }

    public byte[] dump() {
        if (this.bodyDecrypted == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.getLength(this.bodyDecrypted.length)];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.putHead(byteBuffer);
        byteBuffer.put(this.bodyDecrypted);
        this.putTail(byteBuffer);
        byteBuffer = null;
        return byArray;
    }

    protected _08Packet() {
    }

    protected abstract int getLength(int var1);

    protected abstract boolean validateHeader();

    protected abstract int getHeadLength();

    protected abstract int getTailLength();

    protected abstract void putHead(ByteBuffer var1);

    protected abstract void putBody(ByteBuffer var1);

    protected abstract byte[] getBodyBytes(ByteBuffer var1, int var2);

    public abstract int getFamily();

    protected abstract void putTail(ByteBuffer var1);

    protected byte[] encryptBody(byte[] byArray) {
        byte[] byArray2;
        int n = this.getEncryptStart();
        if (n == -1) {
            return byArray;
        }
        int n2 = this.getEncryptLength();
        if (n2 == -1) {
            n2 = byArray.length - n;
        }
        if ((byArray2 = crypter.encrypt(byArray, n, n2, this.getEncryptKey(byArray))) == null) {
            return byArray;
        }
        byte[] byArray3 = byArray2;
        if (byArray.length - n2 > 0) {
            byArray3 = new byte[byArray.length - n2 + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
            System.arraycopy(byArray, n + n2, byArray3, n + byArray2.length, byArray.length - n - n2);
        }
        return byArray3;
    }

    protected byte[] decryptBody(byte[] byArray) {
        byte[] byArray2;
        int n = this.getDecryptStart();
        if (n == -1) {
            return byArray;
        }
        int n2 = this.getDecryptLength();
        if (n2 == -1) {
            n2 = byArray.length - n;
        }
        if ((byArray2 = crypter.decrypt(byArray, n, n2, this.getDecryptKey(byArray))) == null) {
            byArray2 = crypter.decrypt(byArray, n, n2, this.getFallbackDecryptKey(byArray));
        }
        if (byArray2 == null) {
            return null;
        }
        byte[] byArray3 = byArray2;
        if (byArray.length - n2 > 0) {
            byArray3 = new byte[byArray2.length + byArray.length - n2];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
            System.arraycopy(byArray, n + n2, byArray3, n + byArray2.length, byArray.length - n - n2);
        }
        return byArray3;
    }

    protected int getEncryptStart() {
        return 0;
    }

    protected int getEncryptLength() {
        return -1;
    }

    protected int getDecryptStart() {
        return 0;
    }

    protected int getDecryptLength() {
        return -1;
    }

    protected abstract void parseBody(ByteBuffer var1) throws PacketParseException;

    protected abstract void parseHeader(ByteBuffer var1) throws PacketParseException;

    protected abstract void parseTail(ByteBuffer var1) throws PacketParseException;

    public String toString() {
        return "\u5305\u540d: " + this.getPacketName() + " \u5305\u5e8f\u53f7: " + this.sequence;
    }

    public String toDebugString() {
        return "toDebugString not implemented!";
    }

    public boolean equals(Object object) {
        if (object instanceof _08Packet) {
            _08Packet _08Packet2 = (_08Packet)object;
            return this.header == _08Packet2.header && this.command == _08Packet2.command && this.sequence == _08Packet2.sequence;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return _08Packet.hash(this.sequence, this.command);
    }

    public static int hash(char c, char c2) {
        return c << 16 | c2;
    }

    public char getCommand() {
        return this.command;
    }

    public char getSequence() {
        return this.sequence;
    }

    public void setSequence(char c) {
        this.sequence = c;
    }

    public String getPacketName() {
        return "Unknown _08Packet";
    }

    public char getSource() {
        return this.source;
    }

    public boolean isDuplicated() {
        return this.duplicated;
    }

    public void setDuplicated(boolean bl) {
        this.duplicated = bl;
    }

    public byte getHeader() {
        return this.header;
    }

    public void setHeader(byte by) {
        this.header = by;
    }

    public byte[] getDecryptKey(byte[] byArray) {
        return this.decryptKey;
    }

    public void setDecryptKey(byte[] byArray) {
        this.decryptKey = byArray;
    }

    public byte[] getEncryptKey(byte[] byArray) {
        return this.encryptKey;
    }

    public void setEncryptKey(byte[] byArray) {
        this.encryptKey = byArray;
    }

    public byte[] getFallbackDecryptKey(byte[] byArray) {
        return this.fallbackDecryptKey;
    }

    public void setFallbackDecryptKey(byte[] byArray) {
        this.fallbackDecryptKey = byArray;
    }
}

