/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.StringMsgParser;
import java.text.ParseException;
import java.util.List;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class MessageFactoryImpl
implements MessageFactory {
    public Request createRequest(URI uRI, String string, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, ContentTypeHeader contentTypeHeader, Object object) throws ParseException {
        if (uRI == null || string == null || callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || object == null || contentTypeHeader == null) {
            throw new NullPointerException("Null parameters");
        }
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.setRequestURI(uRI);
        sIPRequest.setMethod(string);
        sIPRequest.setCallId(callIdHeader);
        sIPRequest.setCSeq(cSeqHeader);
        sIPRequest.setFrom(fromHeader);
        sIPRequest.setTo(toHeader);
        sIPRequest.setVia(list);
        sIPRequest.setMaxForwards(maxForwardsHeader);
        sIPRequest.setContent(object, contentTypeHeader);
        return sIPRequest;
    }

    public Request createRequest(URI uRI, String string, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, byte[] byArray, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (uRI == null || string == null || callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || byArray == null || contentTypeHeader == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the request", 0);
        }
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.setRequestURI(uRI);
        sIPRequest.setMethod(string);
        sIPRequest.setCallId(callIdHeader);
        sIPRequest.setCSeq(cSeqHeader);
        sIPRequest.setFrom(fromHeader);
        sIPRequest.setTo(toHeader);
        sIPRequest.setVia(list);
        sIPRequest.setMaxForwards(maxForwardsHeader);
        sIPRequest.setHeader((ContentType)contentTypeHeader);
        sIPRequest.setMessageContent(byArray);
        return sIPRequest;
    }

    public Request createRequest(URI uRI, String string, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader) throws ParseException {
        if (uRI == null || string == null || callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the request", 0);
        }
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.setRequestURI(uRI);
        sIPRequest.setMethod(string);
        sIPRequest.setCallId(callIdHeader);
        sIPRequest.setCSeq(cSeqHeader);
        sIPRequest.setFrom(fromHeader);
        sIPRequest.setTo(toHeader);
        sIPRequest.setVia(list);
        sIPRequest.setMaxForwards(maxForwardsHeader);
        return sIPRequest;
    }

    public Response createResponse(int n, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, Object object, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || object == null || contentTypeHeader == null) {
            throw new NullPointerException(" unable to create the response");
        }
        SIPResponse sIPResponse = new SIPResponse();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(n);
        String string = SIPResponse.getReasonPhrase(n);
        if (string == null) {
            throw new ParseException(n + " Unkown  ", 0);
        }
        statusLine.setReasonPhrase(string);
        sIPResponse.setStatusLine(statusLine);
        sIPResponse.setCallId(callIdHeader);
        sIPResponse.setCSeq(cSeqHeader);
        sIPResponse.setFrom(fromHeader);
        sIPResponse.setTo(toHeader);
        sIPResponse.setVia(list);
        sIPResponse.setMaxForwards(maxForwardsHeader);
        sIPResponse.setContent(object, contentTypeHeader);
        return sIPResponse;
    }

    public Response createResponse(int n, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, byte[] byArray, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || byArray == null || contentTypeHeader == null) {
            throw new NullPointerException("Null params ");
        }
        SIPResponse sIPResponse = new SIPResponse();
        sIPResponse.setStatusCode(n);
        sIPResponse.setCallId(callIdHeader);
        sIPResponse.setCSeq(cSeqHeader);
        sIPResponse.setFrom(fromHeader);
        sIPResponse.setTo(toHeader);
        sIPResponse.setVia(list);
        sIPResponse.setMaxForwards(maxForwardsHeader);
        sIPResponse.setHeader((ContentType)contentTypeHeader);
        sIPResponse.setMessageContent(byArray);
        return sIPResponse;
    }

    public Response createResponse(int n, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader) throws ParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the response", 0);
        }
        SIPResponse sIPResponse = new SIPResponse();
        sIPResponse.setStatusCode(n);
        sIPResponse.setCallId(callIdHeader);
        sIPResponse.setCSeq(cSeqHeader);
        sIPResponse.setFrom(fromHeader);
        sIPResponse.setTo(toHeader);
        sIPResponse.setVia(list);
        sIPResponse.setMaxForwards(maxForwardsHeader);
        return sIPResponse;
    }

    public Response createResponse(int n, Request request, ContentTypeHeader contentTypeHeader, Object object) throws ParseException {
        if (request == null || object == null || contentTypeHeader == null) {
            throw new NullPointerException("null parameters");
        }
        SIPRequest sIPRequest = (SIPRequest)request;
        SIPResponse sIPResponse = sIPRequest.createResponse(n);
        sIPResponse.setContent(object, contentTypeHeader);
        return sIPResponse;
    }

    public Response createResponse(int n, Request request, ContentTypeHeader contentTypeHeader, byte[] byArray) throws ParseException {
        if (request == null || byArray == null || contentTypeHeader == null) {
            throw new NullPointerException("null Parameters");
        }
        SIPRequest sIPRequest = (SIPRequest)request;
        SIPResponse sIPResponse = sIPRequest.createResponse(n);
        sIPResponse.setHeader((ContentType)contentTypeHeader);
        sIPResponse.setMessageContent(byArray);
        return sIPResponse;
    }

    public Response createResponse(int n, Request request) throws ParseException {
        if (request == null) {
            throw new NullPointerException("null parameters");
        }
        SIPRequest sIPRequest = (SIPRequest)request;
        SIPResponse sIPResponse = sIPRequest.createResponse(n);
        sIPResponse.removeContent();
        sIPResponse.removeHeader("Content-Type");
        return sIPResponse;
    }

    public Request createRequest(URI uRI, String string, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, ContentTypeHeader contentTypeHeader, byte[] byArray) throws ParseException {
        if (uRI == null || string == null || callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || byArray == null || contentTypeHeader == null) {
            throw new NullPointerException("missing parameters");
        }
        SIPRequest sIPRequest = new SIPRequest();
        sIPRequest.setRequestURI(uRI);
        sIPRequest.setMethod(string);
        sIPRequest.setCallId(callIdHeader);
        sIPRequest.setCSeq(cSeqHeader);
        sIPRequest.setFrom(fromHeader);
        sIPRequest.setTo(toHeader);
        sIPRequest.setVia(list);
        sIPRequest.setMaxForwards(maxForwardsHeader);
        sIPRequest.setContent(byArray, contentTypeHeader);
        return sIPRequest;
    }

    public Response createResponse(int n, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, ContentTypeHeader contentTypeHeader, Object object) throws ParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || object == null || contentTypeHeader == null) {
            throw new NullPointerException("missing parameters");
        }
        SIPResponse sIPResponse = new SIPResponse();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(n);
        String string = SIPResponse.getReasonPhrase(n);
        if (string == null) {
            throw new ParseException(n + " Unknown", 0);
        }
        statusLine.setReasonPhrase(string);
        sIPResponse.setStatusLine(statusLine);
        sIPResponse.setCallId(callIdHeader);
        sIPResponse.setCSeq(cSeqHeader);
        sIPResponse.setFrom(fromHeader);
        sIPResponse.setTo(toHeader);
        sIPResponse.setVia(list);
        sIPResponse.setContent(object, contentTypeHeader);
        return sIPResponse;
    }

    public Response createResponse(int n, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List list, MaxForwardsHeader maxForwardsHeader, ContentTypeHeader contentTypeHeader, byte[] byArray) throws ParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || list == null || maxForwardsHeader == null || byArray == null || contentTypeHeader == null) {
            throw new NullPointerException("missing parameters");
        }
        SIPResponse sIPResponse = new SIPResponse();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(n);
        String string = SIPResponse.getReasonPhrase(n);
        if (string == null) {
            throw new ParseException(n + " : Unknown", 0);
        }
        statusLine.setReasonPhrase(string);
        sIPResponse.setStatusLine(statusLine);
        sIPResponse.setCallId(callIdHeader);
        sIPResponse.setCSeq(cSeqHeader);
        sIPResponse.setFrom(fromHeader);
        sIPResponse.setTo(toHeader);
        sIPResponse.setVia(list);
        sIPResponse.setContent(byArray, contentTypeHeader);
        return sIPResponse;
    }

    public Request createRequest(String string) throws ParseException {
        if (string == null || string.equals("")) {
            return new SIPRequest();
        }
        StringMsgParser stringMsgParser = new StringMsgParser();
        SIPMessage sIPMessage = stringMsgParser.parseSIPMessage(string);
        if (!(sIPMessage instanceof SIPRequest)) {
            throw new ParseException(string, 0);
        }
        return (SIPRequest)sIPMessage;
    }

    public Response createResponse(String string) throws ParseException {
        if (string == null) {
            return new SIPResponse();
        }
        StringMsgParser stringMsgParser = new StringMsgParser();
        SIPMessage sIPMessage = stringMsgParser.parseSIPMessage(string);
        if (!(sIPMessage instanceof SIPResponse)) {
            throw new ParseException(string, 0);
        }
        return (SIPResponse)sIPMessage;
    }
}

