/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.DiskNode;
import org.hsqldb.MemoryNode;
import org.hsqldb.PointerNode;
import org.hsqldb.Row;
import org.hsqldb.Table;

abstract class Node {
    static final int TYPE_MEMORY = 0;
    static final int TYPE_DISK = 1;
    static final int TYPE_POINTER = 2;
    static final int NO_POS = -1;
    protected int iBalance;
    protected Row rData;
    Node nNext;

    Node() {
    }

    static final Node newNode(Row row, int n, Table table) {
        switch (table.getIndexType()) {
            case 0: {
                return new MemoryNode(row);
            }
            case 2: {
                return new PointerNode((CachedRow)row);
            }
        }
        return new DiskNode((CachedRow)row, n);
    }

    static final Node newNode(Row row, DatabaseRowInputInterface databaseRowInputInterface, int n, Table table) throws IOException, SQLException {
        switch (table.getIndexType()) {
            case 0: {
                return new MemoryNode(row);
            }
            case 2: {
                return new PointerNode((CachedRow)row);
            }
        }
        return new DiskNode((CachedRow)row, databaseRowInputInterface, n);
    }

    abstract void delete();

    abstract int getKey();

    abstract void setKey(int var1);

    abstract Row getRow() throws SQLException;

    abstract Node getLeft() throws SQLException;

    abstract void setLeft(Node var1) throws SQLException;

    abstract Node getRight() throws SQLException;

    abstract Node getRightPointer() throws SQLException;

    abstract void setRight(Node var1) throws SQLException;

    abstract Node getParent() throws SQLException;

    abstract boolean isRoot();

    abstract void setParent(Node var1) throws SQLException;

    final int getBalance() throws SQLException {
        return this.iBalance;
    }

    abstract void setBalance(int var1) throws SQLException;

    abstract boolean from() throws SQLException;

    abstract Object[] getData() throws SQLException;

    abstract boolean equals(Node var1) throws SQLException;

    abstract void write(DatabaseRowOutputInterface var1) throws IOException, SQLException;
}

