/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.DTDProcessor;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class DTDHandler
implements DTDProcessor {
    private ScannerState state;
    private Name name;

    DTDHandler(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
    }

    public void setExternalDTD(boolean bl) {
    }

    public void read() throws IOException, ScannerException {
        this.skipDOCTYPE();
    }

    private void skipDOCTYPE() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == '>') {
                this.state.read();
                return;
            }
            if (this.state.currentChar == '<') {
                this.state.read();
                if (this.state.currentChar != '!') continue;
                this.state.read();
                if (this.state.currentChar == '[') {
                    this.state.read();
                    this.skipDTDSect();
                    continue;
                }
                if (this.state.currentChar == '-') {
                    this.state.read();
                    this.skipDTDComment();
                    continue;
                }
                String string = this.name.stringRead();
                if (string.equals("ELEMENT") || string.equals("ATTLIST") || string.equals("ENTITY") || string.equals("NOTATION")) {
                    this.skipDTDELEMENT();
                    continue;
                }
                throw new ScannerException(" '" + this.state.currentChar + "' Expected an ELEMENT,ATTLIST,NOTATION, or ENTITY declaration", this.state);
            }
            this.state.checkedRead();
        }
    }

    private void skipDelimiter(char c) throws IOException, ScannerException {
        if (this.state.currentChar == c) {
            this.state.read();
            while (true) {
                if (this.state.currentChar == c) {
                    this.state.read();
                    return;
                }
                this.state.checkedRead();
            }
        }
    }

    private void skipDTDELEMENT() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == '\"') {
                this.skipDelimiter('\"');
            }
            if (this.state.currentChar == '\'') {
                this.skipDelimiter('\'');
            }
            if (this.state.currentChar == '>') {
                this.state.read();
                return;
            }
            this.state.checkedRead();
        }
    }

    private void skipDTDSect() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == ']') {
                this.state.read();
                if (this.state.currentChar == ']') {
                    this.state.read();
                    if (this.state.currentChar == '>') {
                        this.state.read();
                        return;
                    }
                }
            }
            this.state.checkedRead();
        }
    }

    private void skipDTDComment() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == '-') {
                this.state.read();
                if (this.state.currentChar == '-') {
                    this.state.read();
                    if (this.state.currentChar == '>') {
                        this.state.read();
                        return;
                    }
                }
            }
            this.state.checkedRead();
        }
    }
}

