/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.ant.taskdefs.email.Message;
import org.apache.tools.ant.taskdefs.email.PlainMailer;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EmailTask
extends Task {
    public static final String AUTO = "auto";
    public static final String MIME = "mime";
    public static final String UU = "uu";
    public static final String PLAIN = "plain";
    private String encoding;
    private String host;
    private int port;
    private String subject;
    private Message message;
    private boolean failOnError;
    private boolean includeFileNames;
    private String messageMimeType;
    private EmailAddress from;
    private Vector replyToList;
    private Vector toList;
    private Vector ccList;
    private Vector bccList;
    private Vector files;
    private Vector filesets;
    private String charset;
    private String user;
    private String password;
    private boolean SSL;

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSSL(boolean bl) {
        this.SSL = bl;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding.getValue();
    }

    public void setMailport(int n) {
        this.port = n;
    }

    public void setMailhost(String string) {
        this.host = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setMessage(String string) {
        if (this.message != null) {
            throw new BuildException("Only one message can be sent in an email");
        }
        this.message = new Message(string);
        this.message.setProject(this.getProject());
    }

    public void setMessageFile(File file) {
        if (this.message != null) {
            throw new BuildException("Only one message can be sent in an email");
        }
        this.message = new Message(file);
        this.message.setProject(this.getProject());
    }

    public void setMessageMimeType(String string) {
        this.messageMimeType = string;
    }

    public void addMessage(Message message) throws BuildException {
        if (this.message != null) {
            throw new BuildException("Only one message can be sent in an email");
        }
        this.message = message;
    }

    public void addFrom(EmailAddress emailAddress) {
        if (this.from != null) {
            throw new BuildException("Emails can only be from one address");
        }
        this.from = emailAddress;
    }

    public void setFrom(String string) {
        if (this.from != null) {
            throw new BuildException("Emails can only be from one address");
        }
        this.from = new EmailAddress(string);
    }

    public void addReplyTo(EmailAddress emailAddress) {
        this.replyToList.add(emailAddress);
    }

    public void setReplyTo(String string) {
        this.replyToList.add(new EmailAddress(string));
    }

    public void addTo(EmailAddress emailAddress) {
        this.toList.addElement(emailAddress);
    }

    public void setToList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.toList.addElement(new EmailAddress(stringTokenizer.nextToken()));
        }
    }

    public void addCc(EmailAddress emailAddress) {
        this.ccList.addElement(emailAddress);
    }

    public void setCcList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.ccList.addElement(new EmailAddress(stringTokenizer.nextToken()));
        }
    }

    public void addBcc(EmailAddress emailAddress) {
        this.bccList.addElement(emailAddress);
    }

    public void setBccList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.bccList.addElement(new EmailAddress(stringTokenizer.nextToken()));
        }
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void setFiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            this.files.addElement(this.getProject().resolveFile(stringTokenizer.nextToken()));
        }
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setIncludefilenames(boolean bl) {
        this.includeFileNames = bl;
    }

    public boolean getIncludeFileNames() {
        return this.includeFileNames;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        Message message = this.message;
        Vector vector = (Vector)this.files.clone();
        try {
            try {
                int n;
                Mailer mailer = null;
                boolean bl = false;
                if (this.encoding.equals(MIME) || this.encoding.equals(AUTO) && !bl) {
                    try {
                        mailer = (Mailer)Class.forName("org.apache.tools.ant.taskdefs.email.MimeMailer").newInstance();
                        bl = true;
                        this.log("Using MIME mail", 3);
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to initialise MIME mail: " + throwable.getMessage(), 1);
                    }
                }
                if (!(bl || this.user == null && this.password == null)) {
                    if (this.encoding.equals(UU)) throw new BuildException("SMTP auth only possible with MIME mail");
                    if (this.encoding.equals(PLAIN)) {
                        throw new BuildException("SMTP auth only possible with MIME mail");
                    }
                }
                if (!bl && this.SSL) {
                    if (this.encoding.equals(UU)) throw new BuildException("SSL only possible with MIME mail");
                    if (this.encoding.equals(PLAIN)) {
                        throw new BuildException("SSL only possible with MIME mail");
                    }
                }
                if (this.encoding.equals(UU) || this.encoding.equals(AUTO) && !bl) {
                    try {
                        mailer = (Mailer)Class.forName("org.apache.tools.ant.taskdefs.email.UUMailer").newInstance();
                        bl = true;
                        this.log("Using UU mail", 3);
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to initialise UU mail", 1);
                    }
                }
                if (this.encoding.equals(PLAIN) || this.encoding.equals(AUTO) && !bl) {
                    mailer = new PlainMailer();
                    bl = true;
                    this.log("Using plain mail", 3);
                }
                if (mailer == null) {
                    throw new BuildException("Failed to initialise encoding: " + this.encoding);
                }
                if (this.message == null) {
                    this.message = new Message();
                    this.message.setProject(this.getProject());
                }
                if (this.from == null) throw new BuildException("A from element is required");
                if (this.from.getAddress() == null) {
                    throw new BuildException("A from element is required");
                }
                if (this.toList.isEmpty() && this.ccList.isEmpty() && this.bccList.isEmpty()) {
                    throw new BuildException("At least one of to,cc or bcc must be supplied");
                }
                if (this.messageMimeType != null) {
                    if (this.message.isMimeTypeSpecified()) {
                        throw new BuildException("The mime type can only be specified in one location");
                    }
                    this.message.setMimeType(this.messageMimeType);
                }
                if (this.charset != null) {
                    if (this.message.getCharset() != null) {
                        throw new BuildException("The charset can only be specified in one location");
                    }
                    this.message.setCharset(this.charset);
                }
                Enumeration enumeration = this.filesets.elements();
                block10: while (true) {
                    if (!enumeration.hasMoreElements()) {
                        this.log("Sending email: " + this.subject, 2);
                        this.log("From " + this.from, 3);
                        this.log("ReplyTo " + this.replyToList, 3);
                        this.log("To " + this.toList, 3);
                        this.log("Cc " + this.ccList, 3);
                        this.log("Bcc " + this.bccList, 3);
                        mailer.setHost(this.host);
                        mailer.setPort(this.port);
                        mailer.setUser(this.user);
                        mailer.setPassword(this.password);
                        mailer.setSSL(this.SSL);
                        mailer.setMessage(this.message);
                        mailer.setFrom(this.from);
                        mailer.setReplyToList(this.replyToList);
                        mailer.setToList(this.toList);
                        mailer.setCcList(this.ccList);
                        mailer.setBccList(this.bccList);
                        mailer.setFiles(this.files);
                        mailer.setSubject(this.subject);
                        mailer.setTask(this);
                        mailer.setIncludeFileNames(this.includeFileNames);
                        mailer.send();
                        n = this.files.size();
                    }
                    FileSet fileSet = (FileSet)enumeration.nextElement();
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                    String[] stringArray = directoryScanner.getIncludedFiles();
                    File file = directoryScanner.getBasedir();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= stringArray.length) continue block10;
                        File file2 = new File(file, stringArray[n2]);
                        this.files.addElement(file2);
                        ++n2;
                    }
                    break;
                }
                this.log("Sent email with " + n + " attachment" + (n == 1 ? "" : "s"), 2);
            }
            catch (BuildException buildException) {
                this.log("Failed to send email", 1);
                if (this.failOnError) {
                    throw buildException;
                }
            }
            catch (Exception exception) {
                this.log("Failed to send email", 1);
                if (this.failOnError) {
                    throw new BuildException(exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_18 = null;
            this.message = message;
            this.files = vector;
            throw throwable;
        }
        {
            Object var4_19 = null;
            this.message = message;
            this.files = vector;
            return;
        }
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    private final /* synthetic */ void this() {
        this.encoding = AUTO;
        this.host = "localhost";
        this.port = 25;
        this.subject = null;
        this.message = null;
        this.failOnError = true;
        this.includeFileNames = false;
        this.messageMimeType = null;
        this.from = null;
        this.replyToList = new Vector();
        this.toList = new Vector();
        this.ccList = new Vector();
        this.bccList = new Vector();
        this.files = new Vector();
        this.filesets = new Vector();
        this.charset = null;
        this.user = null;
        this.password = null;
        this.SSL = false;
    }

    public EmailTask() {
        this.this();
    }

    public static class Encoding
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{EmailTask.AUTO, EmailTask.MIME, EmailTask.UU, EmailTask.PLAIN};
        }
    }
}

