/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.SubscriptionStateHeader;

public class SubscriptionState
extends ParametersHeader
implements SubscriptionStateHeader {
    private static final long serialVersionUID = -6673833053927258745L;
    protected int expires = -1;
    protected int retryAfter = -1;
    protected String reasonCode;
    protected String state;

    public SubscriptionState() {
        super("Subscription-State");
    }

    public void setExpires(int n) throws InvalidArgumentException {
        if (n <= 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SubscriptionState, setExpires(), the expires parameter is <=0");
        }
        this.expires = n;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setRetryAfter(int n) throws InvalidArgumentException {
        if (n <= 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, SubscriptionState, setRetryAfter(), the retryAfter parameter is <=0");
        }
        this.retryAfter = n;
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SubscriptionState, setReasonCode(), the reasonCode parameter is null");
        }
        this.reasonCode = string;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, SubscriptionState, setState(), the state parameter is null");
        }
        this.state = string;
    }

    public String encodeBody() {
        String string = "";
        if (this.state != null) {
            string = string + this.state;
        }
        if (this.reasonCode != null) {
            string = string + ";reason=" + this.reasonCode;
        }
        if (this.expires != -1) {
            string = string + ";expires=" + this.expires;
        }
        if (this.retryAfter != -1) {
            string = string + ";retry-after=" + this.retryAfter;
        }
        if (!this.parameters.isEmpty()) {
            string = string + ";" + this.parameters.encode();
        }
        return string;
    }
}

