/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferProxy;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.support.SSLHandler;
import org.apache.mina.util.SessionLog;

public class SSLFilter
extends IoFilterAdapter {
    public static final String SSL_SESSION = SSLFilter.class.getName() + ".SSLSession";
    public static final String DISABLE_ENCRYPTION_ONCE = SSLFilter.class.getName() + ".DisableEncryptionOnce";
    public static final String USE_NOTIFICATION = SSLFilter.class.getName() + ".UseNotification";
    public static final SSLFilterMessage SESSION_SECURED = new SSLFilterMessage("SESSION_SECURED");
    public static final SSLFilterMessage SESSION_UNSECURED = new SSLFilterMessage("SESSION_UNSECURED");
    private static final String NEXT_FILTER = SSLFilter.class.getName() + ".NextFilter";
    private static final String SSL_HANDLER = SSLFilter.class.getName() + ".SSLHandler";
    private SSLContext sslContext;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SSLFilter(SSLContext sslContext) {
        if (sslContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sslContext;
    }

    public SSLSession getSSLSession(IoSession session) {
        return (SSLSession)session.getAttribute(SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSSL(IoSession session) throws SSLException {
        boolean started;
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            if (handler.isOutboundDone()) {
                IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
                handler.destroy();
                handler.init();
                handler.handshake(nextFilter);
                started = true;
            } else {
                started = false;
            }
        }
        handler.flushPostHandshakeEvents();
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSSLStarted(IoSession session) {
        SSLHandler handler = this.getSSLSessionHandler0(session);
        if (handler == null) {
            return false;
        }
        SSLHandler sSLHandler = handler;
        synchronized (sSLHandler) {
            return !handler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSSL(IoSession session) throws SSLException {
        WriteFuture future;
        SSLHandler handler = this.getSSLSessionHandler(session);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute(NEXT_FILTER);
        SSLHandler sSLHandler = handler;
        synchronized (sSLHandler) {
            future = this.initiateClosure(nextFilter, session);
        }
        handler.flushPostHandshakeEvents();
        return future;
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean clientMode) {
        this.client = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (parent.contains(SSLFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one SSLFilter.");
        }
        IoSession session = parent.getSession();
        session.setAttribute(NEXT_FILTER, (Object)nextFilter);
        SSLHandler handler = new SSLHandler(this, this.sslContext, session);
        session.setAttribute(SSL_HANDLER, (Object)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(parent.getSession());
        synchronized (sSLHandler) {
            handler.handshake(nextFilter);
        }
        handler.flushPostHandshakeEvents();
    }

    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session = parent.getSession();
        this.stopSSL(session);
        session.removeAttribute(NEXT_FILTER);
        session.removeAttribute(SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        try {
            SSLHandler sSLHandler = handler;
            synchronized (sSLHandler) {
                if (this.isSSLStarted(session) && SessionLog.isDebugEnabled((IoSession)session)) {
                    SessionLog.debug((IoSession)session, (String)(" Closed: " + this.getSSLSessionHandler(session)));
                }
                handler.destroy();
            }
            handler.flushPostHandshakeEvents();
        }
        finally {
            nextFilter.sessionClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SSLException {
        SSLHandler handler;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            if (!this.isSSLStarted(session) && handler.isInboundDone()) {
                handler.schedulePostHandshakeMessage(nextFilter, message);
            } else {
                ByteBuffer buf = (ByteBuffer)message;
                if (SessionLog.isDebugEnabled((IoSession)session)) {
                    SessionLog.debug((IoSession)session, (String)(" Data Read: " + handler + " (" + buf + ')'));
                }
                try {
                    handler.messageReceived(nextFilter, buf.buf());
                    this.handleSSLData(nextFilter, handler);
                    if (handler.isInboundDone()) {
                        if (handler.isOutboundDone()) {
                            if (SessionLog.isDebugEnabled((IoSession)session)) {
                                SessionLog.debug((IoSession)session, (String)" SSL Session closed.");
                            }
                            handler.destroy();
                        } else {
                            this.initiateClosure(nextFilter, session);
                        }
                        if (buf.hasRemaining()) {
                            handler.schedulePostHandshakeMessage(nextFilter, buf);
                        }
                    }
                }
                catch (SSLException ssle2) {
                    SSLHandshakeException ssle2;
                    if (!handler.isInitialHandshakeComplete()) {
                        SSLHandshakeException newSSLE = new SSLHandshakeException("Initial SSL handshake failed.");
                        newSSLE.initCause(ssle2);
                        ssle2 = newSSLE;
                    }
                    throw ssle2;
                }
            }
        }
        handler.flushPostHandshakeEvents();
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) {
        if (message instanceof EncryptedBuffer) {
            EncryptedBuffer buf = (EncryptedBuffer)((Object)message);
            buf.release();
            nextFilter.messageSent(session, (Object)buf.originalBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws SSLException {
        SSLHandler handler;
        boolean needsFlush = true;
        SSLHandler sSLHandler = handler = this.getSSLSessionHandler(session);
        synchronized (sSLHandler) {
            if (!this.isSSLStarted(session)) {
                handler.schedulePostHandshakeWriteRequest(nextFilter, writeRequest);
            } else if (session.containsAttribute(DISABLE_ENCRYPTION_ONCE)) {
                session.removeAttribute(DISABLE_ENCRYPTION_ONCE);
                handler.schedulePostHandshakeWriteRequest(nextFilter, writeRequest);
            } else {
                ByteBuffer buf = (ByteBuffer)writeRequest.getMessage();
                if (SessionLog.isDebugEnabled((IoSession)session)) {
                    SessionLog.debug((IoSession)session, (String)(" Filtered Write: " + handler));
                }
                if (handler.isWritingEncryptedData()) {
                    if (SessionLog.isDebugEnabled((IoSession)session)) {
                        SessionLog.debug((IoSession)session, (String)("   already encrypted: " + buf));
                    }
                    handler.schedulePostHandshakeWriteRequest(nextFilter, writeRequest);
                } else if (handler.isInitialHandshakeComplete()) {
                    if (SessionLog.isDebugEnabled((IoSession)session)) {
                        SessionLog.debug((IoSession)session, (String)(" encrypt: " + buf));
                    }
                    int pos = buf.position();
                    handler.encrypt(buf.buf());
                    buf.position(pos);
                    EncryptedBuffer encryptedBuffer = new EncryptedBuffer(SSLHandler.copy(handler.getOutNetBuffer()), buf);
                    if (SessionLog.isDebugEnabled((IoSession)session)) {
                        SessionLog.debug((IoSession)session, (String)(" encrypted buf: " + (Object)((Object)encryptedBuffer)));
                    }
                    handler.schedulePostHandshakeWriteRequest(nextFilter, new IoFilter.WriteRequest((Object)encryptedBuffer, writeRequest.getFuture()));
                } else {
                    if (!session.isConnected()) {
                        if (SessionLog.isDebugEnabled((IoSession)session)) {
                            SessionLog.debug((IoSession)session, (String)" Write request on closed session.");
                        }
                    } else {
                        if (SessionLog.isDebugEnabled((IoSession)session)) {
                            SessionLog.debug((IoSession)session, (String)" Handshaking is not complete yet. Buffering write request.");
                        }
                        handler.schedulePreHandshakeWriteRequest(nextFilter, writeRequest);
                    }
                    needsFlush = false;
                }
            }
        }
        if (needsFlush) {
            handler.flushPostHandshakeEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        block9: {
            WriteFuture future;
            block8: {
                SSLHandler handler = this.getSSLSessionHandler(session);
                future = null;
                try {
                    SSLHandler sSLHandler = handler;
                    synchronized (sSLHandler) {
                        if (this.isSSLStarted(session)) {
                            future = this.initiateClosure(nextFilter, session);
                        }
                    }
                    handler.flushPostHandshakeEvents();
                    if (future != null) break block8;
                }
                catch (Throwable throwable) {
                    if (future == null) {
                        nextFilter.filterClose(session);
                    } else {
                        future.addListener(new IoFutureListener(nextFilter, session){
                            final /* synthetic */ IoFilter.NextFilter val$nextFilter;
                            final /* synthetic */ IoSession val$session;
                            {
                                this.val$nextFilter = nextFilter;
                                this.val$session = ioSession;
                            }

                            public void operationComplete(IoFuture future) {
                                this.val$nextFilter.filterClose(this.val$session);
                            }
                        });
                    }
                    throw throwable;
                }
                nextFilter.filterClose(session);
                break block9;
            }
            future.addListener(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SSLHandler handler = this.getSSLSessionHandler(session);
        if (!handler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture((IoSession)session);
        }
        WriteFuture future = handler.writeNetBuffer(nextFilter);
        if (handler.isInboundDone()) {
            handler.destroy();
        }
        if (session.containsAttribute(USE_NOTIFICATION)) {
            handler.schedulePostHandshakeMessage(nextFilter, SESSION_UNSECURED);
        }
        return future;
    }

    private void handleSSLData(IoFilter.NextFilter nextFilter, SSLHandler handler) throws SSLException {
        if (handler.isInitialHandshakeComplete()) {
            handler.flushPreHandshakeEvents();
        }
        handler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, handler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SSLHandler handler) {
        IoSession session = handler.getSession();
        if (!handler.getAppBuffer().hasRemaining()) {
            return;
        }
        if (SessionLog.isDebugEnabled((IoSession)session)) {
            SessionLog.debug((IoSession)session, (String)(" appBuffer: " + handler.getAppBuffer()));
        }
        ByteBuffer readBuffer = SSLHandler.copy(handler.getAppBuffer());
        if (SessionLog.isDebugEnabled((IoSession)session)) {
            SessionLog.debug((IoSession)session, (String)(" app data read: " + readBuffer + " (" + readBuffer.getHexDump() + ')'));
        }
        handler.schedulePostHandshakeMessage(nextFilter, readBuffer);
    }

    private SSLHandler getSSLSessionHandler(IoSession session) {
        SSLHandler handler = this.getSSLSessionHandler0(session);
        if (handler == null) {
            throw new IllegalStateException();
        }
        if (handler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return handler;
    }

    private SSLHandler getSSLSessionHandler0(IoSession session) {
        return (SSLHandler)session.getAttribute(SSL_HANDLER);
    }

    private static class EncryptedBuffer
    extends ByteBufferProxy {
        private final ByteBuffer originalBuffer;

        private EncryptedBuffer(ByteBuffer buf, ByteBuffer originalBuffer) {
            super(buf);
            this.originalBuffer = originalBuffer;
        }
    }

    public static class SSLFilterMessage {
        private final String name;

        private SSLFilterMessage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

