/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateListener;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.OutgoingSnacRequestListener;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacPacketListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.conn.RateChange;
import net.kano.joscar.snaccmd.conn.RateClassInfo;
import net.kano.joscar.snaccmd.conn.RateInfoCmd;

public class RateMonitor {
    public static final Object ERRTYPE_RATE_LISTENER = "ERRTYPE_RATE_LISTENER";
    public static final int ERRORMARGIN_DEFAULT = 100;
    private static final Logger logger = Logger.getLogger("net.kano.joscar.ratelim");
    private ClientSnacProcessor snacProcessor;
    private final CopyOnWriteArrayList listeners = new CopyOnWriteArrayList();
    private final Object listenerEventLock = new Object();
    private Map classToMonitor = new HashMap(10);
    private Map typeToMonitor = new HashMap(500);
    private RateClassMonitor defaultMonitor = null;
    private int errorMargin = 100;
    private OutgoingSnacRequestListener requestListener = new OutgoingSnacRequestListener(){

        public void handleSent(SnacRequestSentEvent snacRequestSentEvent) {
            RateMonitor.this.updateRate(snacRequestSentEvent);
        }

        public void handleTimeout(SnacRequestTimeoutEvent snacRequestTimeoutEvent) {
        }
    };
    private SnacResponseListener responseListener = new SnacResponseListener(){

        public void handleResponse(SnacResponseEvent snacResponseEvent) {
            SnacCommand snacCommand = snacResponseEvent.getSnacCommand();
            if (snacCommand instanceof RateInfoCmd) {
                RateInfoCmd rateInfoCmd = (RateInfoCmd)snacCommand;
                RateMonitor.this.setRateClasses(rateInfoCmd.getRateClassInfos());
            }
        }
    };
    private SnacPacketListener packetListener = new SnacPacketListener(){

        public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
            RateChange rateChange;
            RateClassInfo rateClassInfo;
            SnacCommand snacCommand = snacPacketEvent.getSnacCommand();
            if (snacCommand instanceof RateChange && (rateClassInfo = (rateChange = (RateChange)snacCommand).getRateInfo()) != null) {
                int n = rateChange.getChangeCode();
                RateMonitor.this.updateRateClass(n, rateClassInfo);
            }
        }
    };

    public RateMonitor(ClientSnacProcessor clientSnacProcessor) {
        DefensiveTools.checkNull(clientSnacProcessor, "processor");
        this.snacProcessor = clientSnacProcessor;
        clientSnacProcessor.addGlobalRequestListener(this.requestListener);
        clientSnacProcessor.addPacketListener(this.packetListener);
        clientSnacProcessor.addGlobalResponseListener(this.responseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach() {
        ClientSnacProcessor clientSnacProcessor;
        Object object = this;
        synchronized (object) {
            if (this.snacProcessor == null) {
                return;
            }
            this.snacProcessor.removeGlobalRequestListener(this.requestListener);
            this.snacProcessor.removePacketListener(this.packetListener);
            this.snacProcessor.removeGlobalResponseListener(this.responseListener);
            clientSnacProcessor = this.snacProcessor;
            this.snacProcessor = null;
        }
        object = this.listenerEventLock;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                RateListener rateListener = (RateListener)iterator.next();
                rateListener.detached(this, clientSnacProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.typeToMonitor.clear();
        this.classToMonitor.clear();
        this.defaultMonitor = null;
        Object object = this.listenerEventLock;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                RateListener rateListener = (RateListener)iterator.next();
                rateListener.reset(this);
            }
        }
    }

    public final synchronized ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    public final void addListener(RateListener rateListener) {
        DefensiveTools.checkNull(rateListener, "l");
        this.listeners.addIfAbsent(rateListener);
    }

    public final void removeListener(RateListener rateListener) {
        DefensiveTools.checkNull(rateListener, "l");
        this.listeners.remove(rateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRateClasses(RateClassInfo[] rateClassInfoArray) {
        Object object;
        DefensiveTools.checkNull(rateClassInfoArray, "rateInfos");
        rateClassInfoArray = (RateClassInfo[])rateClassInfoArray.clone();
        DefensiveTools.checkNullElements(rateClassInfoArray, "rateInfos");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Got rate classes for monitor " + this);
        }
        Object object2 = this;
        synchronized (object2) {
            this.reset();
            for (int i = 0; i < rateClassInfoArray.length; ++i) {
                object = rateClassInfoArray[i];
                this.setRateClass((RateClassInfo)object);
            }
        }
        object2 = this.listenerEventLock;
        synchronized (object2) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                object = (RateListener)iterator.next();
                try {
                    object.gotRateClasses(this);
                }
                catch (Throwable throwable) {
                    this.handleException(ERRTYPE_RATE_LISTENER, throwable, object);
                }
            }
        }
    }

    private synchronized void setRateClass(RateClassInfo rateClassInfo) {
        DefensiveTools.checkNull(rateClassInfo, "rateInfo");
        RateClassMonitor rateClassMonitor = new RateClassMonitor(this, rateClassInfo);
        this.classToMonitor.put(new Integer(rateClassInfo.getRateClass()), rateClassMonitor);
        CmdType[] cmdTypeArray = rateClassInfo.getCommands();
        if (cmdTypeArray != null) {
            if (cmdTypeArray.length == 0) {
                if (this.defaultMonitor == null) {
                    this.defaultMonitor = rateClassMonitor;
                }
            } else {
                for (int i = 0; i < cmdTypeArray.length; ++i) {
                    this.typeToMonitor.put(cmdTypeArray[i], rateClassMonitor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRateClass(int n, RateClassInfo rateClassInfo) {
        DefensiveTools.checkRange(n, "changeCode", 0);
        DefensiveTools.checkNull(rateClassInfo, "rateInfo");
        RateClassMonitor rateClassMonitor = this.getMonitor(rateClassInfo.getRateClass());
        rateClassMonitor.updateRateInfo(n, rateClassInfo);
        Object object = this.listenerEventLock;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                RateListener rateListener = (RateListener)iterator.next();
                try {
                    rateListener.rateClassUpdated(this, rateClassMonitor, rateClassInfo);
                }
                catch (Throwable throwable) {
                    this.handleException(ERRTYPE_RATE_LISTENER, throwable, rateListener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Object object, Throwable throwable, Object object2) {
        ClientSnacProcessor clientSnacProcessor;
        RateMonitor rateMonitor = this;
        synchronized (rateMonitor) {
            clientSnacProcessor = this.snacProcessor;
        }
        if (clientSnacProcessor != null) {
            clientSnacProcessor.getFlapProcessor().handleException(object, throwable, object2);
        } else {
            logger.warning("Rate monitor couldn't process error because not attached to SNAC processor: " + throwable.getMessage() + " (reason obj: " + object2 + ")");
        }
    }

    private void updateRate(SnacRequestSentEvent snacRequestSentEvent) {
        CmdType cmdType = CmdType.ofCmd(snacRequestSentEvent.getRequest().getCommand());
        RateClassMonitor rateClassMonitor = this.getMonitor(cmdType);
        if (rateClassMonitor == null) {
            return;
        }
        rateClassMonitor.updateRate(snacRequestSentEvent.getSentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireLimitedEvent(RateClassMonitor rateClassMonitor, boolean bl) {
        Object object = this.listenerEventLock;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                RateListener rateListener = (RateListener)iterator.next();
                try {
                    rateListener.rateClassLimited(this, rateClassMonitor, bl);
                }
                catch (Throwable throwable) {
                    this.handleException(ERRTYPE_RATE_LISTENER, throwable, rateListener);
                }
            }
        }
    }

    public final synchronized void setErrorMargin(int n) throws IllegalArgumentException {
        DefensiveTools.checkRange(n, "errorMargin", 0);
        this.errorMargin = n;
    }

    public final synchronized int getErrorMargin() {
        return this.errorMargin;
    }

    private synchronized RateClassMonitor getMonitor(int n) {
        Integer n2 = new Integer(n);
        return (RateClassMonitor)this.classToMonitor.get(n2);
    }

    public final synchronized RateClassMonitor getMonitor(CmdType cmdType) {
        DefensiveTools.checkNull(cmdType, "type");
        RateClassMonitor rateClassMonitor = (RateClassMonitor)this.typeToMonitor.get(cmdType);
        if (rateClassMonitor == null) {
            rateClassMonitor = this.defaultMonitor;
        }
        return rateClassMonitor;
    }

    public final synchronized RateClassMonitor[] getMonitors() {
        return this.classToMonitor.values().toArray(new RateClassMonitor[0]);
    }
}

