/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.io.XPPPacketReader;
import org.jivesoftware.whack.ExternalComponentManager;
import org.jivesoftware.whack.SocketReadThread;
import org.jivesoftware.whack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.StreamError;

public class ExternalComponent
implements Component {
    private static String CHARSET = "UTF-8";
    private Component component;
    private ExternalComponentManager manager;
    private Socket socket;
    private XMLWriter xmlSerializer;
    private XmlPullParserFactory factory = null;
    private XPPPacketReader reader = null;
    private Writer writer = null;
    private boolean shutdown = false;
    private String connectionID;
    private String domain;
    private String subdomain;
    private String host;
    private int port;
    private SocketFactory socketFactory;
    private ThreadPoolExecutor threadPool;
    private SocketReadThread readerThread;

    public ExternalComponent(Component component, ExternalComponentManager manager) {
        this(component, manager, 25);
    }

    public ExternalComponent(Component component, ExternalComponentManager manager, int maxThreads) {
        this.component = component;
        this.manager = manager;
        this.threadPool = new ThreadPoolExecutor(1, maxThreads, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void connect(String host, int port, SocketFactory socketFactory, String subdomain) throws ComponentException {
        try {
            this.socket = socketFactory.createSocket(host, port);
            this.domain = subdomain + "." + host;
            this.subdomain = subdomain;
            this.host = host;
            this.port = port;
            this.socketFactory = socketFactory;
            try {
                this.factory = XmlPullParserFactory.newInstance();
                this.reader = new XPPPacketReader();
                this.reader.setXPPFactory(this.factory);
                this.reader.getXPPParser().setInput(new InputStreamReader(this.socket.getInputStream(), CHARSET));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), CHARSET));
                StringBuilder stream = new StringBuilder();
                stream.append("<stream:stream");
                stream.append(" xmlns=\"jabber:component:accept\"");
                stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
                stream.append(" to=\"" + this.domain + "\">");
                this.writer.write(stream.toString());
                this.writer.flush();
                stream = null;
                XmlPullParser xpp = this.reader.getXPPParser();
                int eventType = xpp.getEventType();
                while (eventType != 2) {
                    eventType = xpp.next();
                }
                this.connectionID = xpp.getAttributeValue("", "id");
                if (xpp.getAttributeValue("", "from") != null) {
                    this.domain = xpp.getAttributeValue("", "from");
                }
                this.xmlSerializer = new XMLWriter(this.writer);
                stream = new StringBuilder();
                stream.append("<handshake>");
                stream.append(StringUtils.hash(this.connectionID + this.manager.getSecretKey(subdomain)));
                stream.append("</handshake>");
                this.writer.write(stream.toString());
                this.writer.flush();
                stream = null;
                try {
                    Element doc = this.reader.parseDocument().getRootElement();
                    if ("error".equals(doc.getName())) {
                        StreamError error = new StreamError(doc);
                        this.socket.close();
                        this.socket = null;
                        throw new ComponentException(error);
                    }
                }
                catch (DocumentException e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new ComponentException(e);
                }
                catch (XmlPullParserException e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw new ComponentException(e);
                }
            }
            catch (XmlPullParserException e) {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw new ComponentException(e);
            }
        }
        catch (UnknownHostException uhe) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ComponentException(uhe);
        }
        catch (IOException ioe) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new ComponentException(ioe);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public String getName() {
        return this.component.getName();
    }

    public String getDescription() {
        return this.component.getDescription();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    ExternalComponentManager getManager() {
        return this.manager;
    }

    public void processPacket(final Packet packet) {
        this.threadPool.execute(new Runnable(){

            public void run() {
                ExternalComponent.this.component.processPacket(packet);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.xmlSerializer.write(packet.getElement());
                this.xmlSerializer.flush();
            }
            catch (IOException e) {
                this.manager.getLog().error(e);
                try {
                    this.manager.removeComponent(this.subdomain);
                }
                catch (ComponentException e1) {
                    this.manager.getLog().error(e);
                }
            }
        }
    }

    public void initialize(JID jid, ComponentManager componentManager) {
        this.component.initialize(jid, componentManager);
    }

    public void start() {
        this.readerThread = new SocketReadThread(this, this.reader);
        this.readerThread.setDaemon(true);
        this.readerThread.start();
    }

    public void shutdown() {
        this.shutdown = true;
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        if (this.readerThread != null) {
            this.readerThread.shutdown();
        }
        this.threadPool.shutdown();
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                Writer writer = this.writer;
                synchronized (writer) {
                    try {
                        this.writer.write("</stream:stream>");
                        this.xmlSerializer.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.manager.getLog().error(e);
            }
        }
    }

    public void connectionLost() {
        this.readerThread = null;
        boolean isConnected = false;
        while (!isConnected && !this.shutdown) {
            try {
                this.connect(this.host, this.port, this.socketFactory, this.subdomain);
                isConnected = true;
                if (!this.shutdown) continue;
                this.disconnect();
            }
            catch (ComponentException e) {
                this.manager.getLog().error("Error trying to reconnect with the server", e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

