/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import net.sf.antcontrib.inifile.IniFile;
import net.sf.antcontrib.inifile.IniProperty;
import net.sf.antcontrib.inifile.IniSection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class IniFileTask
extends Task {
    private File source;
    private File dest;
    private Vector operations = new Vector();

    public Set createSet() {
        Set set = new Set();
        this.operations.add(set);
        return set;
    }

    public Remove createRemove() {
        Remove remove = new Remove();
        this.operations.add(remove);
        return remove;
    }

    public void setSource(File file) {
        this.source = file;
    }

    public void setDest(File file) {
        this.dest = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.dest == null) {
            throw new BuildException("You must supply a dest file to write to.");
        }
        IniFile iniFile = null;
        try {
            iniFile = this.readIniFile(this.source);
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        Iterator iterator = ((AbstractList)this.operations).iterator();
        IniOperation iniOperation = null;
        while (iterator.hasNext()) {
            iniOperation = (IniOperation)iterator.next();
            iniOperation.execute(this.getProject(), iniFile);
        }
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(this.dest);
                iniFile.write(fileWriter);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IniFile readIniFile(File file) throws IOException {
        FileReader fileReader = null;
        IniFile iniFile = new IniFile();
        if (file == null) {
            return iniFile;
        }
        try {
            fileReader = new FileReader(file);
            iniFile.read(fileReader);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        catch (IOException iOException) {}
        return iniFile;
    }

    public final class Set
    extends IniOperation {
        private String value;
        private String operation;

        public void setValue(String string) {
            this.value = string;
        }

        public void setOperation(String string) {
            this.operation = string;
        }

        protected void operate(IniFile iniFile) {
            String string = this.getSection();
            String string2 = this.getProperty();
            IniSection iniSection = iniFile.getSection(string);
            if (iniSection == null) {
                iniSection = new IniSection(string);
                iniFile.setSection(iniSection);
            }
            if (string2 != null) {
                if (this.operation != null) {
                    if ("+".equals(this.operation)) {
                        IniProperty iniProperty = iniSection.getProperty(string2);
                        this.value = iniProperty.getValue();
                        int n = Integer.parseInt(this.value) + 1;
                        this.value = String.valueOf(n);
                    } else if ("-".equals(this.operation)) {
                        IniProperty iniProperty = iniSection.getProperty(string2);
                        this.value = iniProperty.getValue();
                        int n = Integer.parseInt(this.value) - 1;
                        this.value = String.valueOf(n);
                    }
                }
                iniSection.setProperty(new IniProperty(string2, this.value));
            }
        }
    }

    public static final class Remove
    extends IniOperation {
        protected void operate(IniFile iniFile) {
            String string = this.getSection();
            String string2 = this.getProperty();
            if (string2 == null) {
                iniFile.removeSection(string);
            } else {
                IniSection iniSection = iniFile.getSection(string);
                if (iniSection != null) {
                    iniSection.removeProperty(string2);
                }
            }
        }
    }

    public static abstract class IniOperation {
        private String section;
        private String property;
        private String ifCond;
        private String unlessCond;

        public String getSection() {
            return this.section;
        }

        public void setSection(String string) {
            this.section = string;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String string) {
            this.property = string;
        }

        public void setIf(String string) {
            this.ifCond = string;
        }

        public void setUnless(String string) {
            this.unlessCond = string;
        }

        public boolean isActive(Project project) {
            if (this.ifCond != null && project.getProperty(this.ifCond) == null) {
                return false;
            }
            return this.unlessCond == null || project.getProperty(this.unlessCond) == null;
        }

        public void execute(Project project, IniFile iniFile) {
            if (this.isActive(project)) {
                this.operate(iniFile);
            }
        }

        protected abstract void operate(IniFile var1);
    }
}

