/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack.container;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.whack.container.ComponentClassLoader;
import org.jivesoftware.whack.container.ComponentServlet;
import org.jivesoftware.whack.container.ServerContainer;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentFinder {
    private File componentDirectory;
    private Map<String, Component> components;
    private Map<Component, ComponentClassLoader> classloaders;
    private Map<Component, File> componentDirs;
    private Map<Component, String> componentDomains;
    private boolean setupMode = true;
    private ComponentManager manager;
    private ScheduledExecutorService executor = null;

    public ComponentFinder(ServerContainer server, File componentDir) {
        this.componentDirectory = componentDir;
        this.components = new HashMap<String, Component>();
        this.componentDirs = new HashMap<Component, File>();
        this.classloaders = new HashMap<Component, ComponentClassLoader>();
        this.componentDomains = new HashMap<Component, String>();
        this.manager = server.getManager();
        this.setupMode = server.isSetupMode();
    }

    public void start() {
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.scheduleWithFixedDelay(new ComponentMonitor(), 0L, 10L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        for (String subdomain : this.componentDomains.values()) {
            try {
                this.manager.removeComponent(subdomain);
            }
            catch (ComponentException e) {
                this.manager.getLog().error("Error shutting down component", e);
            }
        }
        this.components.clear();
        this.componentDirs.clear();
        this.classloaders.clear();
        this.componentDomains.clear();
    }

    public Collection<Component> getComponents() {
        return Collections.unmodifiableCollection(this.components.values());
    }

    public Component getComponent(String name) {
        return this.components.get(name);
    }

    public File getComponentDirectory(Component component) {
        return this.componentDirs.get(component);
    }

    private void loadComponent(File componentDir) {
        if (this.setupMode) {
            return;
        }
        this.manager.getLog().debug("Loading components " + componentDir.getName());
        Component component = null;
        try {
            File componentConfig = new File(componentDir, "component.xml");
            if (componentConfig.exists()) {
                Element adminElement;
                SAXReader saxReader = new SAXReader();
                Document componentXML = saxReader.read(componentConfig);
                ComponentClassLoader classLoader = new ComponentClassLoader(componentDir);
                String className = componentXML.selectSingleNode("/component/class").getText();
                String subdomain = componentXML.selectSingleNode("/component/subdomain").getText();
                Class aClass = classLoader.loadClass(className);
                component = (Component)aClass.newInstance();
                this.manager.addComponent(subdomain, component);
                this.components.put(componentDir.getName(), component);
                this.componentDirs.put(component, componentDir);
                this.classloaders.put(component, classLoader);
                this.componentDomains.put(component, subdomain);
                File webXML = new File(componentDir, "web" + File.separator + "web.xml");
                if (webXML.exists()) {
                    ComponentServlet.registerServlets(this, component, webXML);
                }
                if ((adminElement = (Element)componentXML.selectSingleNode("/component/adminconsole")) != null) {
                    Element imageEl = (Element)adminElement.selectSingleNode("/component/adminconsole/global/logo-image");
                    if (imageEl != null) {
                        imageEl.setText("components/" + componentDir.getName() + "/" + imageEl.getText());
                    }
                    if ((imageEl = (Element)adminElement.selectSingleNode("/component/adminconsole/global/login-image")) != null) {
                        imageEl.setText("components/" + componentDir.getName() + "/" + imageEl.getText());
                    }
                }
            } else {
                this.manager.getLog().warn("Component " + componentDir + " could not be loaded: no component.xml file found");
            }
        }
        catch (Exception e) {
            this.manager.getLog().error("Error loading component", e);
        }
    }

    public void unloadComponent(String componentName) {
        this.manager.getLog().debug("Unloading component " + componentName);
        Component component = this.components.get(componentName);
        if (component == null) {
            return;
        }
        File webXML = new File(this.componentDirectory + File.separator + componentName + File.separator + "web" + File.separator + "web.xml");
        if (webXML.exists()) {
            ComponentServlet.unregisterServlets(webXML);
        }
        ComponentClassLoader classLoader = this.classloaders.get(component);
        try {
            this.manager.removeComponent(this.componentDomains.get(component));
        }
        catch (ComponentException e) {
            this.manager.getLog().error("Error shutting down component", e);
        }
        classLoader.destroy();
        this.components.remove(componentName);
        this.componentDirs.remove(component);
        this.classloaders.remove(component);
        this.componentDomains.remove(component);
    }

    public Class loadClass(String className, Component component) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ComponentClassLoader loader = this.classloaders.get(component);
        return loader.loadClass(className);
    }

    public String getName(Component component) {
        String name = this.getElementValue(component, "/component/name");
        if (name != null) {
            return name;
        }
        return this.componentDirs.get(component).getName();
    }

    public String getDescription(Component component) {
        return this.getElementValue(component, "/component/description");
    }

    public String getAuthor(Component component) {
        return this.getElementValue(component, "/component/author");
    }

    public String getVersion(Component component) {
        return this.getElementValue(component, "/component/version");
    }

    private String getElementValue(Component component, String xpath) {
        File componentDir = this.componentDirs.get(component);
        if (componentDir == null) {
            return null;
        }
        try {
            SAXReader saxReader;
            Document componentXML;
            Element element;
            File componentConfig = new File(componentDir, "component.xml");
            if (componentConfig.exists() && (element = (Element)(componentXML = (saxReader = new SAXReader()).read(componentConfig)).selectSingleNode(xpath)) != null) {
                return element.getTextTrim();
            }
        }
        catch (Exception e) {
            this.manager.getLog().error(e);
        }
        return null;
    }

    private class ComponentMonitor
    implements Runnable {
        private ComponentMonitor() {
        }

        public void run() {
            try {
                File[] jars = ComponentFinder.this.componentDirectory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String fileName = pathname.getName().toLowerCase();
                        return fileName.endsWith(".jar") || fileName.endsWith(".war");
                    }
                });
                for (int i = 0; i < jars.length; ++i) {
                    File jarFile = jars[i];
                    String componentName = jarFile.getName().substring(0, jarFile.getName().length() - 4).toLowerCase();
                    File dir = new File(ComponentFinder.this.componentDirectory, componentName);
                    if (!dir.exists()) {
                        this.unzipComponent(componentName, jarFile, dir);
                        continue;
                    }
                    if (jarFile.lastModified() <= dir.lastModified()) continue;
                    ComponentFinder.this.unloadComponent(componentName);
                    System.gc();
                    while (!this.deleteDir(dir)) {
                        ComponentFinder.this.manager.getLog().error("Error unloading component " + componentName + ". " + "Will attempt again momentarily.");
                        Thread.sleep(5000L);
                    }
                    this.unzipComponent(componentName, jarFile, dir);
                }
                File[] dirs = ComponentFinder.this.componentDirectory.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                for (int i = 0; i < dirs.length; ++i) {
                    File dirFile = dirs[i];
                    if (ComponentFinder.this.components.containsKey(dirFile.getName())) continue;
                    ComponentFinder.this.loadComponent(dirFile);
                }
                if (ComponentFinder.this.components.size() > jars.length + 1) {
                    ArrayList<String> toDelete = new ArrayList<String>();
                    for (String componentName : ComponentFinder.this.components.keySet()) {
                        File file = new File(ComponentFinder.this.componentDirectory, componentName + ".jar");
                        if (file.exists()) continue;
                        toDelete.add(componentName);
                    }
                    for (String componentName : toDelete) {
                        ComponentFinder.this.unloadComponent(componentName);
                        System.gc();
                        while (!this.deleteDir(new File(ComponentFinder.this.componentDirectory, componentName))) {
                            ComponentFinder.this.manager.getLog().error("Error unloading component " + componentName + ". " + "Will attempt again momentarily.");
                            Thread.sleep(5000L);
                        }
                    }
                }
            }
            catch (Exception e) {
                ComponentFinder.this.manager.getLog().error(e);
            }
        }

        private void unzipComponent(String componentName, File file, File dir) {
            try {
                JarFile zipFile = new JarFile(file);
                if (((ZipFile)zipFile).getEntry("component.xml") == null) {
                    return;
                }
                dir.mkdir();
                ComponentFinder.this.manager.getLog().debug("Extracting component: " + componentName);
                Enumeration<? extends ZipEntry> e = ((ZipFile)zipFile).entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = (JarEntry)e.nextElement();
                    File entryFile = new File(dir, entry.getName());
                    if (entry.getName().toLowerCase().endsWith("manifest.mf") || entry.isDirectory()) continue;
                    entryFile.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(entryFile);
                    InputStream zin = ((ZipFile)zipFile).getInputStream(entry);
                    byte[] b = new byte[512];
                    int len = 0;
                    while ((len = zin.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                    out.flush();
                    out.close();
                    zin.close();
                }
                zipFile.close();
                zipFile = null;
            }
            catch (Exception e) {
                ComponentFinder.this.manager.getLog().error(e);
            }
        }

        public boolean deleteDir(File dir) {
            if (dir.isDirectory()) {
                String[] children = dir.list();
                for (int i = 0; i < children.length; ++i) {
                    boolean success = this.deleteDir(new File(dir, children[i]));
                    if (success) continue;
                    return false;
                }
            }
            return dir.delete();
        }
    }
}

