/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors.modifiedselector;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.Algorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.Cache;
import org.apache.tools.ant.types.selectors.modifiedselector.DigestAlgorithm;
import org.apache.tools.ant.types.selectors.modifiedselector.EqualComparator;
import org.apache.tools.ant.types.selectors.modifiedselector.PropertiesfileCache;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModifiedSelector
extends BaseExtendSelector {
    private Cache cache;
    private Algorithm algorithm;
    private Comparator comparator;
    private boolean update;
    private boolean selectDirectories;
    private boolean isConfigured;
    private AlgorithmName algoName;
    private CacheName cacheName;
    private ComparatorName compName;
    private Vector configParameter;
    private Vector specialParameter;

    public void verifySettings() {
        this.configure();
        if (this.cache == null) {
            this.setError("Cache must be set.");
        } else if (this.algorithm == null) {
            this.setError("Algorithm must be set.");
        } else if (!this.cache.isValid()) {
            this.setError("Cache must be proper configured.");
        } else if (!this.algorithm.isValid()) {
            this.setError("Algorithm must be proper configured.");
        }
    }

    public void configure() {
        Object object;
        if (this.isConfigured) {
            return;
        }
        this.isConfigured = true;
        Project project = this.getProject();
        String string = "cache.properties";
        File file = null;
        file = project != null ? new File(project.getBaseDir(), string) : new File(string);
        this.cache = new PropertiesfileCache(file);
        this.algorithm = new DigestAlgorithm();
        this.comparator = new EqualComparator();
        this.update = true;
        this.selectDirectories = true;
        Object object2 = this.configParameter.iterator();
        while (object2.hasNext()) {
            object = (Parameter)object2.next();
            if (((Parameter)object).getName().indexOf(".") > 0) {
                this.specialParameter.add(object);
                continue;
            }
            this.useParameter((Parameter)object);
        }
        this.configParameter = new Vector();
        object2 = null;
        object = "org.apache.tools.ant.types.selectors.cacheselector";
        if (this.algorithm == null) {
            if ("hashvalue".equals(this.algoName.getValue())) {
                object2 = (String)object + ".HashvalueAlgorithm";
            } else if ("digest".equals(this.algoName.getValue())) {
                object2 = (String)object + ".DigestAlgorithm";
            }
            if (object2 != null) {
                try {
                    this.algorithm = (Algorithm)Class.forName((String)object2).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (this.cache == null) {
            if ("propertyfile".equals(this.cacheName.getValue())) {
                object2 = (String)object + ".PropertiesfileCache";
            }
            if (object2 != null) {
                try {
                    this.cache = (Cache)Class.forName(object2).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (this.comparator == null) {
            if ("equal".equals(this.compName.getValue())) {
                object2 = (String)object + ".EqualComparator";
            } else if ("role".equals(this.compName.getValue())) {
                object2 = "java.text.RuleBasedCollator";
            }
            if (object2 != null) {
                try {
                    this.comparator = (Comparator)Class.forName((String)object2).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        Iterator iterator = this.specialParameter.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            this.useParameter(parameter);
        }
        this.specialParameter = new Vector();
    }

    public boolean isSelected(File file, String string, File file2) {
        boolean bl;
        this.validate();
        File file3 = new File(file, string);
        if (file3.isDirectory()) {
            return this.selectDirectories;
        }
        String string2 = String.valueOf(this.cache.get(file3.getAbsolutePath()));
        String string3 = this.algorithm.getValue(file3);
        boolean bl2 = false;
        if (this.comparator.compare(string2, string3) != 0) {
            bl2 = bl = true;
        }
        if (this.update && !string2.equals(string3)) {
            this.cache.put(file3.getAbsolutePath(), string3);
            this.cache.save();
        }
        return bl;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public void setSeldirs(boolean bl) {
        this.selectDirectories = bl;
    }

    public void addParam(String string, Object object) {
        Parameter parameter = new Parameter();
        parameter.setName(string);
        parameter.setValue(String.valueOf(object));
        this.configParameter.add(parameter);
    }

    public void addParam(Parameter parameter) {
        this.configParameter.add(parameter);
    }

    public void setParameters(Parameter[] parameterArray) {
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                this.configParameter.add(parameterArray[n]);
                ++n;
            }
        }
    }

    public void useParameter(Parameter parameter) {
        String string = parameter.getName();
        String string2 = parameter.getValue();
        if ("cache".equals(string)) {
            CacheName cacheName = new CacheName();
            cacheName.setValue(string2);
            this.setCache(cacheName);
        } else if ("algorithm".equals(string)) {
            AlgorithmName algorithmName = new AlgorithmName();
            algorithmName.setValue(string2);
            this.setAlgorithm(algorithmName);
        } else if ("comparator".equals(string)) {
            ComparatorName comparatorName = new ComparatorName();
            comparatorName.setValue(string2);
            this.setComparator(comparatorName);
        } else if ("update".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string2);
            this.setUpdate(bl);
        } else if ("seldirs".equals(string)) {
            boolean bl = "true".equalsIgnoreCase(string2);
            this.setSeldirs(bl);
        } else if (string.startsWith("cache.")) {
            String string3 = string.substring(6);
            this.tryToSetAParameter(this.cache, string3, string2);
        } else if (string.startsWith("algorithm.")) {
            String string4 = string.substring(10);
            this.tryToSetAParameter(this.algorithm, string4, string2);
        } else if (string.startsWith("comparator.")) {
            String string5 = string.substring(11);
            this.tryToSetAParameter(this.comparator, string5, string2);
        } else {
            this.setError("Invalid parameter " + string);
        }
    }

    protected void tryToSetAParameter(Object object, String string, String string2) {
        Project project = this.getProject() != null ? this.getProject() : new Project();
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(project, object.getClass());
        try {
            introspectionHelper.setAttribute(project, object, string, string2);
        }
        catch (BuildException buildException) {}
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{modifiedselector");
        stringBuffer.append(" update=").append(this.update);
        stringBuffer.append(" seldirs=").append(this.selectDirectories);
        stringBuffer.append(" cache=").append(this.cache);
        stringBuffer.append(" algorithm=").append(this.algorithm);
        stringBuffer.append(" comparator=").append(this.comparator);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(CacheName cacheName) {
        this.cacheName = cacheName;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmName algorithmName) {
        this.algoName = algorithmName;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ComparatorName comparatorName) {
        this.compName = comparatorName;
    }

    private final /* synthetic */ void this() {
        this.cache = null;
        this.algorithm = null;
        this.comparator = null;
        this.update = true;
        this.selectDirectories = true;
        this.isConfigured = false;
        this.algoName = null;
        this.cacheName = null;
        this.compName = null;
        this.configParameter = new Vector();
        this.specialParameter = new Vector();
    }

    public ModifiedSelector() {
        this.this();
    }

    public static class AlgorithmName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"hashvalue", "digest"};
        }
    }

    public static class CacheName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"propertyfile"};
        }
    }

    public static class ComparatorName
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"equal", "rule"};
        }
    }
}

