/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.chat;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.chat.ChatCommand;

public abstract class UsersCmd
extends ChatCommand {
    private final FullUserInfo[] users;

    protected UsersCmd(int n, SnacPacket snacPacket) {
        super(n);
        FullUserInfo fullUserInfo;
        DefensiveTools.checkNull(snacPacket, "packet");
        LinkedList<FullUserInfo> linkedList = new LinkedList<FullUserInfo>();
        ByteBlock byteBlock = snacPacket.getData();
        while ((fullUserInfo = FullUserInfo.readUserInfo(byteBlock)) != null) {
            linkedList.add(fullUserInfo);
            byteBlock = byteBlock.subBlock(fullUserInfo.getTotalSize());
        }
        this.users = linkedList.toArray(new FullUserInfo[0]);
    }

    protected UsersCmd(int n, FullUserInfo[] fullUserInfoArray) {
        super(n);
        this.users = (FullUserInfo[])(fullUserInfoArray == null ? null : fullUserInfoArray.clone());
    }

    public final FullUserInfo[] getUsers() {
        return (FullUserInfo[])(this.users == null ? null : this.users.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.users != null) {
            for (int i = 0; i < this.users.length; ++i) {
                this.users[i].write(outputStream);
            }
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + " for " + this.users.length + " users";
    }
}

