/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sftp;

import com.jcraft.jsch.JSchException;
import com.voxeo.exceptions.VException;
import com.voxeo.sftp.ISftpCallback;
import com.voxeo.sftp.ISftpClient;
import com.voxeo.sftp.ISftpClientPool;
import com.voxeo.sftp.ISftpTemplate;
import com.voxeo.utils.IRetryTemplate;
import java.io.IOException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpTemplate
implements ISftpTemplate {
    private ISftpClientPool pool;
    private IRetryTemplate retryTemplate;

    @Override
    public <T> T go(final ISftpCallback callback) throws IOException {
        try {
            if (this.retryTemplate != null) {
                Object result = this.retryTemplate.execute(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        Object result = SftpTemplate.this.doGo(callback);
                        return result;
                    }
                });
                return result;
            }
            Object result = this.doGo(callback);
            return (T)result;
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new VException(exception);
        }
    }

    private Object doGo(ISftpCallback callback) throws Exception {
        ISftpClient sftp = this.pool.checkout();
        try {
            Object object = callback.doWithSftp(sftp);
            return object;
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
        finally {
            if (sftp != null) {
                this.pool.checkin(sftp);
            }
        }
    }

    public void setPool(ISftpClientPool pool) {
        this.pool = pool;
    }

    public void setRetryTemplate(IRetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }
}

